/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authentication.ResetPasswordException;
import org.xwiki.security.authentication.ResetPasswordManager;
import org.xwiki.security.authentication.ResetPasswordRequestResponse;
import org.xwiki.security.authentication.internal.AuthenticationMailSender;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Singleton
@Named(value="R140600000XWIKI19869DataMigrationListener")
public class R140600000XWIKI19869DataMigrationListener
extends AbstractEventListener {
    static final String NAME = "R140600000XWIKI19869DataMigrationListener";
    private static final List<Event> EVENT_LIST = Collections.singletonList(new ApplicationReadyEvent());
    private static final String FILENAME = "140600000XWIKI19869DataMigration-users.txt";
    private static final String MAIL_TEMPLATE = "140600000XWIKI19869-mail.txt";
    private static final String SUBJECT_MARKER = "subject:";
    @Inject
    private Provider<ResetPasswordManager> resetPasswordManagerProvider;
    @Inject
    private Provider<AuthenticationMailSender> resetPasswordMailSenderProvider;
    @Inject
    private Provider<UserReferenceResolver<String>> userReferenceResolverProvider;
    @Inject
    private Provider<ContextualLocalizationManager> contextualLocalizationManagerProvider;
    @Inject
    private Provider<UserPropertiesResolver> userPropertiesResolver;
    @Inject
    @Named(value="xwikiproperties")
    private Provider<ConfigurationSource> propertiesConfigurationProvider;
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;

    public R140600000XWIKI19869DataMigrationListener() {
        super(NAME, EVENT_LIST);
    }

    public void onEvent(Event event, Object source, Object data) {
        ConfigurationSource configurationSource = (ConfigurationSource)this.propertiesConfigurationProvider.get();
        boolean sendSecurityEmail = (Boolean)configurationSource.getProperty("security.migration.R140600000XWIKI19869.sendSecurityEmail", (Object)true);
        boolean sendResetPasswordEmail = (Boolean)configurationSource.getProperty("security.migration.R140600000XWIKI19869.sendResetPasswordEmail", (Object)true);
        File migrationFile = new File(this.environment.getPermanentDirectory(), FILENAME);
        if ((sendSecurityEmail || sendResetPasswordEmail) && Files.exists(migrationFile.toPath(), new LinkOption[0])) {
            this.handleMigrationFile(migrationFile, sendSecurityEmail, sendResetPasswordEmail);
        }
    }

    private void handleMigrationFile(File migrationFile, boolean sendSecurityEmail, boolean sendResetPasswordEmail) {
        try {
            List<String> serializedReferences = Files.readAllLines(migrationFile.toPath());
            HashSet<String> exploredReference = new HashSet<String>();
            Pair<String, String> mailData = this.getMailData();
            for (String serializedReference : serializedReferences) {
                if (exploredReference.contains(serializedReference)) continue;
                UserReference userReference = ((UserReferenceResolver)this.userReferenceResolverProvider.get()).resolve((Object)serializedReference, new Object[0]);
                UserProperties userProperties = ((UserPropertiesResolver)this.userPropertiesResolver.get()).resolve(userReference, new Object[0]);
                if (userProperties.getEmail() != null) {
                    this.handleResetPassword(userReference, mailData, sendSecurityEmail, sendResetPasswordEmail);
                } else {
                    this.logger.warn("Reset email cannot be sent for user [{}] as no email address is provided.", (Object)userReference);
                }
                exploredReference.add(serializedReference);
            }
            Files.delete(migrationFile.toPath());
        }
        catch (IOException e) {
            this.logger.warn("Error while trying to read the data migration file to ask user to reset their password the root cause error was [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void handleResetPassword(UserReference userReference, Pair<String, String> mailData, boolean sendSecurityEmail, boolean sendResetPasswordEmail) {
        ResetPasswordManager resetPasswordManager = (ResetPasswordManager)this.resetPasswordManagerProvider.get();
        try {
            ResetPasswordRequestResponse resetPasswordRequestResponse = resetPasswordManager.requestResetPassword(userReference);
            if (!StringUtils.isEmpty((CharSequence)resetPasswordRequestResponse.getVerificationCode())) {
                if (sendSecurityEmail) {
                    ((AuthenticationMailSender)this.resetPasswordMailSenderProvider.get()).sendAuthenticationSecurityEmail(userReference, (String)mailData.getLeft(), (String)mailData.getRight());
                }
                if (sendResetPasswordEmail) {
                    resetPasswordManager.sendResetPasswordEmailRequest(resetPasswordRequestResponse);
                }
            }
        }
        catch (ResetPasswordException e) {
            this.logger.warn("Error when handling user [{}] for sending security and/or reset password email: [{}]", (Object)userReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            this.logger.debug("Full stack trace for the reset password request: ", (Throwable)e);
        }
    }

    private Pair<String, String> getMailData() {
        File mailTemplate = new File(this.environment.getPermanentDirectory(), MAIL_TEMPLATE);
        Pair<String, String> result = this.getMailDataFallback();
        if (Files.exists(mailTemplate.toPath(), new LinkOption[0])) {
            try {
                List<String> mailLines = Files.readAllLines(mailTemplate.toPath());
                result = this.getMailData(mailLines, result);
            }
            catch (IOException e) {
                this.logger.warn("Error while trying to read the security email template, fallback on default mail subject and content. Root cause error: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return result;
    }

    private Pair<String, String> getMailData(List<String> mailLines, Pair<String, String> fallback) {
        Pair result = fallback;
        if (!mailLines.isEmpty()) {
            String subject = mailLines.get(0).toLowerCase().startsWith(SUBJECT_MARKER) ? mailLines.remove(0).substring(SUBJECT_MARKER.length()) : (String)fallback.getLeft();
            String content = String.join((CharSequence)"\n", mailLines);
            result = Pair.of((Object)subject, (Object)content);
        }
        return result;
    }

    private Pair<String, String> getMailDataFallback() {
        ContextualLocalizationManager contextualLocalizationManager = (ContextualLocalizationManager)this.contextualLocalizationManagerProvider.get();
        String translationPrefix = "security.authentication.migration1400600000XWIKI19869.email.";
        String subject = contextualLocalizationManager.getTranslationPlain(translationPrefix + "subject", new Object[0]);
        String content = contextualLocalizationManager.getTranslationPlain(translationPrefix + "content", new Object[0]);
        return Pair.of((Object)subject, (Object)content);
    }
}

