/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.security.authentication.RetrieveUsernameException;
import org.xwiki.security.authentication.RetrieveUsernameManager;
import org.xwiki.security.authentication.internal.AuthenticationMailSender;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultRetrieveUsernameManager
implements RetrieveUsernameManager {
    private static final String HQL_QUERY = ", BaseObject obj, StringProperty prop where obj.name = doc.fullName and obj.className = 'XWiki.XWikiUsers' and prop.id.id = obj.id and prop.id.name = 'email' and LOWER(prop.value) = :email";
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;
    @Inject
    private UserReferenceResolver<String> userReferenceResolver;
    @Inject
    private Provider<AuthenticationMailSender> authenticationMailSenderProvider;

    public Set<UserReference> findUsers(String requestEmail) throws RetrieveUsernameException {
        Set<UserReference> result = this.findUsers(requestEmail, false);
        if (result.isEmpty()) {
            result = this.findUsers(requestEmail, true);
        }
        return result;
    }

    private Set<UserReference> findUsers(String requestEmail, boolean mainWiki) throws RetrieveUsernameException {
        try {
            Query query = this.queryManager.createQuery(HQL_QUERY, "hql").bindValue("email", (Object)StringUtils.toRootLowerCase((String)requestEmail));
            if (mainWiki) {
                query = query.setWiki(((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getMainWikiId());
            }
            List userSerializedReferences = query.execute();
            return userSerializedReferences.stream().map(x$0 -> this.userReferenceResolver.resolve(x$0, new Object[0])).collect(Collectors.toSet());
        }
        catch (QueryException e) {
            throw new RetrieveUsernameException(String.format("Error when performing the query to retrieve user from email [%s]", requestEmail), (Throwable)e);
        }
    }

    public void sendRetrieveUsernameEmail(String requestEmail, Set<UserReference> userReferences) throws RetrieveUsernameException {
        if (userReferences.isEmpty()) {
            throw new RetrieveUsernameException("The list of user is empty.");
        }
        try {
            InternetAddress email = new InternetAddress(requestEmail);
            ((AuthenticationMailSender)this.authenticationMailSenderProvider.get()).sendRetrieveUsernameEmail(email, userReferences);
        }
        catch (AddressException e) {
            throw new RetrieveUsernameException(String.format("Error with the given email adresse: [%s]", requestEmail), (Throwable)e);
        }
    }
}

