/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.security.authentication.RegistrationConfiguration;

@Component
@Singleton
public class DefaultRegistrationConfiguration
implements RegistrationConfiguration {
    @Inject
    @Named(value="registration")
    private ConfigurationSource configuration;
    @Inject
    @Named(value="wiki")
    private ConfigurationSource wikiPreferencesConfigurationSource;

    public int getPasswordMinimumLength() {
        int length = (Integer)this.configuration.getProperty("passwordLength", (Object)6);
        return length > 1 ? length : 6;
    }

    public Set<RegistrationConfiguration.PasswordRules> getPasswordRules() {
        HashSet<RegistrationConfiguration.PasswordRules> result = new HashSet<RegistrationConfiguration.PasswordRules>();
        if ((Integer)this.configuration.getProperty("passwordRuleOneLowerCaseEnabled", (Object)0) == 1) {
            result.add(RegistrationConfiguration.PasswordRules.ONE_LOWER_CASE_CHARACTER);
        }
        if ((Integer)this.configuration.getProperty("passwordRuleOneNumberEnabled", (Object)0) == 1) {
            result.add(RegistrationConfiguration.PasswordRules.ONE_NUMBER_CHARACTER);
        }
        if ((Integer)this.configuration.getProperty("passwordRuleOneSymbolEnabled", (Object)0) == 1) {
            result.add(RegistrationConfiguration.PasswordRules.ONE_SYMBOL_CHARACTER);
        }
        if ((Integer)this.configuration.getProperty("passwordRuleOneUpperCaseEnabled", (Object)0) == 1) {
            result.add(RegistrationConfiguration.PasswordRules.ONE_UPPER_CASE_CHARACTER);
        }
        return result;
    }

    public boolean isCaptchaRequired() {
        return (Integer)this.configuration.getProperty("requireCaptcha", (Object)0) == 1;
    }

    public boolean isEmailValidationRequired() {
        return (Integer)this.wikiPreferencesConfigurationSource.getProperty("use_email_verification", (Object)0) == 1;
    }

    public boolean isAutoLoginEnabled() {
        return (Integer)this.configuration.getProperty("loginButton_autoLogin_enabled", (Object)0) == 1;
    }

    public boolean isLoginEnabled() {
        return (Integer)this.configuration.getProperty("loginButton_enabled", (Object)1) == 1;
    }
}

