/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.MailState;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusResult;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.SessionFactory;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.security.authentication.ResetPasswordException;
import org.xwiki.security.authentication.RetrieveUsernameException;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component(roles={AuthenticationMailSender.class})
@Singleton
public class AuthenticationMailSender {
    private static final String XWIKI_SPACE = "XWiki";
    private static final LocalDocumentReference RESET_PASSWORD_MAIL_TEMPLATE_REFERENCE = new LocalDocumentReference("XWiki", "ResetPasswordMailContent");
    private static final LocalDocumentReference RETRIEVE_USERNAME_TEMPLATE_REFERENCE = new LocalDocumentReference("XWiki", "ForgotUsernameMailContent");
    private static final String NO_REPLY = "no-reply@";
    private static final String FROM = "from";
    private static final String TO = "to";
    @Inject
    private MailSenderConfiguration mailSenderConfiguration;
    @Inject
    private DocumentReferenceResolver<EntityReference> documentReferenceResolver;
    @Inject
    @Named(value="template")
    private MimeMessageFactory<MimeMessage> mimeMessageFactory;
    @Inject
    @Named(value="text")
    private MimeMessageFactory<MimeMessage> textMimeMessageFactory;
    @Inject
    private MailSender mailSender;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="database")
    private Provider<MailListener> mailListenerProvider;
    @Inject
    private Provider<UserPropertiesResolver> userPropertiesResolverProvider;
    @Inject
    private UserReferenceSerializer<String> userReferenceSerializer;
    @Inject
    private Logger logger;

    public void sendResetPasswordEmail(String username, InternetAddress email, URL resetPasswordURL) throws ResetPasswordException {
        HashMap<String, Object> velocityVariables = new HashMap<String, Object>();
        velocityVariables.put("userName", username);
        velocityVariables.put("passwordResetURL", resetPasswordURL.toExternalForm());
        Map<String, Object> parameters = this.getEmailParameters(email, "Reset Password", velocityVariables);
        try {
            MimeMessage message = (MimeMessage)this.mimeMessageFactory.createMessage((Object)this.documentReferenceResolver.resolve((Object)RESET_PASSWORD_MAIL_TEMPLATE_REFERENCE, new Object[0]), parameters);
            if (!this.sendMessage(message)) {
                this.logger.debug("The reset password mail to [{}] has not been sent after 1 second, check the status in the administration", (Object)username);
            }
        }
        catch (MessagingException e) {
            throw new ResetPasswordException(this.localizationManager.getTranslationPlain("xe.admin.passwordReset.error.emailFailed", new Object[0]), (Throwable)e);
        }
    }

    public void sendAuthenticationSecurityEmail(UserReference userReference, String subject, String mailContent) throws ResetPasswordException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        Object fromAddress = this.mailSenderConfiguration.getFromAddress();
        if (StringUtils.isEmpty((CharSequence)fromAddress)) {
            fromAddress = NO_REPLY + context.getRequest().getServerName();
        }
        UserProperties userProperties = ((UserPropertiesResolver)this.userPropertiesResolverProvider.get()).resolve(userReference, new Object[0]);
        InternetAddress email = userProperties.getEmail();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(FROM, fromAddress);
        parameters.put(TO, email);
        parameters.put("subject", subject);
        String localizedError = this.localizationManager.getTranslationPlain("security.authentication.security.email.error", new Object[0]);
        try {
            MimeMessage message = (MimeMessage)this.textMimeMessageFactory.createMessage((Object)mailContent, parameters);
            if (!this.sendMessage(message)) {
                this.logger.info("The security mail to [{}] has not been sent after 1 second, check the status in the administration of the wiki.", (Object)userReference);
            }
        }
        catch (MessagingException e) {
            throw new ResetPasswordException(localizedError, (Throwable)e);
        }
    }

    public void sendRetrieveUsernameEmail(InternetAddress email, Set<UserReference> userReferences) throws RetrieveUsernameException {
        HashMap<String, Object> velocityVariables = new HashMap<String, Object>();
        List usernames = userReferences.stream().map(arg_0 -> this.userReferenceSerializer.serialize(arg_0)).collect(Collectors.toList());
        velocityVariables.put("usernames", usernames);
        Map<String, Object> parameters = this.getEmailParameters(email, "Forgot Username", velocityVariables);
        try {
            MimeMessage message = (MimeMessage)this.mimeMessageFactory.createMessage((Object)this.documentReferenceResolver.resolve((Object)RETRIEVE_USERNAME_TEMPLATE_REFERENCE, new Object[0]), parameters);
            this.sendMessage(message);
        }
        catch (MessagingException e) {
            throw new RetrieveUsernameException(this.localizationManager.getTranslationPlain("xe.admin.forgotUsername.error.emailFailed", new Object[0]), (Throwable)e);
        }
    }

    private Map<String, Object> getEmailParameters(InternetAddress email, String type, Map<String, Object> velocityVariables) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        Object fromAddress = this.mailSenderConfiguration.getFromAddress();
        if (StringUtils.isEmpty((CharSequence)fromAddress)) {
            fromAddress = NO_REPLY + context.getRequest().getServerName();
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(FROM, fromAddress);
        parameters.put(TO, email);
        parameters.put("language", ((XWikiContext)this.contextProvider.get()).getLocale());
        parameters.put("type", type);
        parameters.put("velocityVariables", velocityVariables);
        return parameters;
    }

    private boolean sendMessage(MimeMessage message) throws MessagingException {
        MailListener mailListener = (MailListener)this.mailListenerProvider.get();
        this.mailSender.sendAsynchronously(Collections.singleton(message), this.sessionFactory.create(Collections.emptyMap()), mailListener);
        MailStatusResult mailStatusResult = mailListener.getMailStatusResult();
        mailStatusResult.waitTillProcessed(1000L);
        Iterator mailErrors = mailStatusResult.getAllErrors();
        if (mailErrors != null && mailErrors.hasNext()) {
            MailStatus lastError = (MailStatus)mailErrors.next();
            throw new MessagingException(lastError.getErrorDescription());
        }
        if (mailStatusResult.isProcessed() && mailStatusResult.getAll().hasNext()) {
            MailStatus mailStatus = (MailStatus)mailStatusResult.getAll().next();
            MailState mailState = MailState.parse((String)mailStatus.getState());
            return mailState == MailState.SEND_SUCCESS;
        }
        return false;
    }
}

