/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication;

import java.util.Set;
import java.util.regex.Pattern;
import org.xwiki.component.annotation.Role;

@Role
public interface RegistrationConfiguration {
    public static final int DEFAULT_MINIMUM_PASSWORD_LENGTH = 6;

    public int getPasswordMinimumLength();

    public Set<PasswordRules> getPasswordRules();

    public boolean isCaptchaRequired();

    public boolean isEmailValidationRequired();

    public boolean isAutoLoginEnabled();

    public boolean isLoginEnabled();

    public static enum PasswordRules {
        ONE_LOWER_CASE_CHARACTER(".*[a-z]+.*"),
        ONE_UPPER_CASE_CHARACTER(".*[A-Z]+.*"),
        ONE_SYMBOL_CHARACTER(".*[_\\W]+.*"),
        ONE_NUMBER_CHARACTER(".*[0-9]+.*");

        private final String regularExpression;

        private PasswordRules(String expression) {
            this.regularExpression = expression;
        }

        public Pattern getPattern() {
            return Pattern.compile(this.regularExpression);
        }
    }
}

