/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.solr.internal;

import com.xpn.xwiki.XWikiContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.query.SecureQuery;
import org.xwiki.search.solr.internal.api.SolrInstance;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="solr")
@Singleton
public class SolrQueryExecutor
implements QueryExecutor {
    public static final String SOLR = "solr";
    private static final String PARAM_SUPPORTED_LOCALES = "xwiki.supportedLocales";
    @Inject
    protected Logger logger;
    @Inject
    protected AuthorizationManager authorization;
    @Inject
    protected SolrInstance solrInstance;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<SolrDocument> solrDocumentReferenceResolver;
    @Inject
    private JobProgressManager progress;

    public <T> List<T> execute(Query query) throws QueryException {
        this.progress.startStep((Object)query, "query.solr.progress.execute", "Execute Solr query [{}]", new Object[]{query});
        this.progress.pushLevelProgress(3, (Object)query);
        try {
            this.progress.startStep((Object)query, "query.solr.progress.execute.prepare", "Prepare", new Object[0]);
            SolrQuery solrQuery = this.createSolrQuery(query);
            this.progress.startStep((Object)query, "query.solr.progress.execute.execute", "Execute", new Object[0]);
            QueryResponse response = this.solrInstance.query((SolrParams)solrQuery);
            this.progress.startStep((Object)query, "query.solr.progress.execute.filter", "Filter", new Object[0]);
            ArrayList<DocumentReference> usersToCheck = new ArrayList<DocumentReference>(2);
            if (query instanceof SecureQuery) {
                if (((SecureQuery)query).isCurrentUserChecked()) {
                    usersToCheck.add(((XWikiContext)this.xcontextProvider.get()).getUserReference());
                }
                if (((SecureQuery)query).isCurrentAuthorChecked()) {
                    usersToCheck.add(((XWikiContext)this.xcontextProvider.get()).getAuthorReference());
                }
            } else {
                usersToCheck.add(((XWikiContext)this.xcontextProvider.get()).getUserReference());
                usersToCheck.add(((XWikiContext)this.xcontextProvider.get()).getAuthorReference());
            }
            if (!usersToCheck.isEmpty()) {
                this.filterResponse(response, usersToCheck);
            }
            List<QueryResponse> list = Arrays.asList(response);
            return list;
        }
        catch (Exception e) {
            throw new QueryException("Exception while executing query", query, (Throwable)e);
        }
        finally {
            this.progress.popLevelProgress((Object)query);
            this.progress.endStep((Object)query);
        }
    }

    private SolrQuery createSolrQuery(Query query) {
        SolrQuery solrQuery = new SolrQuery(query.getStatement());
        if (query.getOffset() > 0) {
            solrQuery.setStart(Integer.valueOf(query.getOffset()));
        }
        if (query.getLimit() > 0) {
            solrQuery.setRows(Integer.valueOf(query.getLimit()));
        }
        for (Map.Entry entry : query.getNamedParameters().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Iterable) {
                solrQuery.set((String)entry.getKey(), this.toStringArray((Iterable)value));
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                solrQuery.set((String)entry.getKey(), this.toStringArray(value));
                continue;
            }
            solrQuery.set((String)entry.getKey(), new String[]{String.valueOf(value)});
        }
        if (!solrQuery.getParameterNames().contains(PARAM_SUPPORTED_LOCALES)) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            solrQuery.set(PARAM_SUPPORTED_LOCALES, new String[]{StringUtils.join((Iterable)xcontext.getWiki().getAvailableLocales(xcontext), (String)",")});
        }
        return solrQuery;
    }

    private String[] toStringArray(Object array) {
        int length = Array.getLength(array);
        String[] args = new String[length];
        for (int i = 0; i < length; ++i) {
            args[i] = String.valueOf(Array.get(array, i));
        }
        return args;
    }

    private String[] toStringArray(Iterable iterable) {
        ArrayList<String> args = new ArrayList<String>();
        for (Object obj : iterable) {
            args.add(String.valueOf(obj));
        }
        return args.toArray(new String[args.size()]);
    }

    protected void filterResponse(QueryResponse response, List<DocumentReference> usersToCheck) {
        SolrDocumentList results = response.getResults();
        long numResults = results.size();
        results.removeIf(result -> {
            boolean keep = false;
            try {
                DocumentReference resultDocumentReference = this.solrDocumentReferenceResolver.resolve(result, new Object[0]);
                keep = this.isAllowed(resultDocumentReference, usersToCheck);
            }
            catch (Exception e) {
                this.logger.warn("Removing bad result: {}", result, (Object)e);
            }
            return !keep;
        });
        long numFilteredResults = numResults - (long)results.size();
        long numFound = Math.max(0L, response.getResults().getNumFound() - numFilteredResults);
        results.setNumFound(numFound);
    }

    protected boolean isAllowed(DocumentReference resultDocumentReference, List<DocumentReference> usersToCheck) {
        for (DocumentReference user : usersToCheck) {
            if (this.authorization.hasAccess(Right.VIEW, user, (EntityReference)resultDocumentReference)) continue;
            return false;
        }
        return true;
    }
}

