/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.reference;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.reference.AbstractSolrReferenceResolver;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@Named(value="object")
@Singleton
public class ObjectSolrReferenceResolver
extends AbstractSolrReferenceResolver {
    @Inject
    @Named(value="object_property")
    private Provider<SolrReferenceResolver> objectPropertyResolverProvider;
    @Inject
    @Named(value="document")
    private Provider<SolrReferenceResolver> documentResolverProvider;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;

    public List<EntityReference> getReferences(EntityReference objectReference) throws SolrIndexerException {
        XWikiDocument document;
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        result.add(objectReference);
        DocumentReference documentReference = new DocumentReference(objectReference.getParent());
        try {
            document = this.getDocument(documentReference);
        }
        catch (Exception e) {
            throw new SolrIndexerException("Failed to get document for object [" + String.valueOf(objectReference) + "]", e);
        }
        BaseObject object = document.getXObject(objectReference);
        if (object != null) {
            for (Object field : object.getFieldList()) {
                BaseProperty objectProperty = (BaseProperty)field;
                ObjectPropertyReference objectPropertyReference = (ObjectPropertyReference)objectProperty.getReference();
                try {
                    ((SolrReferenceResolver)this.objectPropertyResolverProvider.get()).getReferences((EntityReference)objectPropertyReference).forEach(result::add);
                }
                catch (Exception e) {
                    this.logger.error("Failed to resolve references for object property [" + String.valueOf(objectPropertyReference) + "]", (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public String getQuery(EntityReference reference) throws SolrIndexerException {
        BaseObjectReference objectReference = new BaseObjectReference(reference);
        StringBuilder builder = new StringBuilder();
        EntityReference documentReference = reference.extractReference(EntityType.DOCUMENT);
        builder.append(((SolrReferenceResolver)this.documentResolverProvider.get()).getQuery(documentReference));
        builder.append(" AND ");
        builder.append("class");
        builder.append(':');
        builder.append(ClientUtils.escapeQueryChars((String)((String)this.localSerializer.serialize((EntityReference)objectReference.getXClassReference(), new Object[0]))));
        builder.append(" AND ");
        builder.append("number");
        builder.append(':');
        builder.append(ClientUtils.escapeQueryChars((String)String.valueOf(objectReference.getObjectNumber())));
        return builder.toString();
    }
}

