/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.migration;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.XWikiSolrCore;
import org.xwiki.search.solr.internal.SolrSchemaUtils;
import org.xwiki.search.solr.internal.api.SolrInstance;

@Component
@Named(value="R141005000XWIKI20575XWIKI20619")
@Singleton
public class R141005000XWIKI20575XWIKI20619DataMigration
implements HibernateDataMigration {
    public static final String HINT = "R141005000XWIKI20575XWIKI20619";
    private static final String DYNAMIC_FIELD_ROOT_NAME = "*__";
    private static final String DYNAMIC_FIELD_PTBR_NAME = "*_pt_BR";
    @Inject
    private SolrInstance solrInstance;
    @Inject
    private Solr solr;
    @Inject
    private Execution execution;
    @Inject
    private SolrSchemaUtils solrSchemaUtils;
    @Inject
    private Logger logger;

    private XWikiContext getXWikiContext() {
        ExecutionContext context = this.execution.getContext();
        return (XWikiContext)context.getProperty("xwikicontext");
    }

    public String getName() {
        return HINT;
    }

    public String getDescription() {
        return "Add potentially missing dynamic field and empty the Solr Search Core to trigger indexing of pages for fixing a regression.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(141005000);
    }

    public void migrate() throws DataMigrationException {
        try {
            XWikiSolrCore core = this.solr.getCore("search");
            Map<String, Map<String, Object>> dynamicFields = this.solrSchemaUtils.getDynamicFields(core, true);
            this.maybeAddField(core, DYNAMIC_FIELD_ROOT_NAME, "text_general", dynamicFields);
            this.maybeAddField(core, DYNAMIC_FIELD_PTBR_NAME, "text_pt_BR", dynamicFields);
            this.solrInstance.deleteByQuery("*:*");
            this.solrInstance.commit();
        }
        catch (IOException | SolrServerException | SolrException e) {
            throw new DataMigrationException("Error while performing Solr query to empty the search core", e);
        }
    }

    private void maybeAddField(XWikiSolrCore core, String name, String type, Map<String, Map<String, Object>> dynamicFields) throws SolrException {
        if (!dynamicFields.containsKey(name)) {
            this.solrSchemaUtils.setField(core, name, type, true, "multiValued", true, "stored", true, "indexed", true);
            this.solrSchemaUtils.commit(core);
            this.logger.info("Missing dynamic field [{}] has been added.", (Object)name);
        } else {
            this.logger.info("Dynamic field [{}] was already defined.", (Object)name);
        }
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return this.getXWikiContext().isMainWiki();
    }

    public String getPreHibernateLiquibaseChangeLog() throws DataMigrationException {
        return null;
    }

    public String getLiquibaseChangeLog() throws DataMigrationException {
        return null;
    }
}

