/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;

public class XWikiSolrInputDocument
extends SolrInputDocument {
    private static final long serialVersionUID = 1L;
    private int length;
    private final Map<String, Set<Object>> uniqueFields = new HashMap<String, Set<Object>>();

    public int getLength() {
        return this.length;
    }

    public void setField(String name, Object value) {
        super.setField(name, value);
        if (value instanceof String) {
            String stringValue = (String)value;
            this.length += stringValue.length();
        } else if (value instanceof byte[]) {
            byte[] bytesValue = (byte[])value;
            this.length += bytesValue.length;
        }
        this.uniqueFields.remove(name);
    }

    public SolrInputField removeField(String name) {
        this.uniqueFields.remove(name);
        return super.removeField(name);
    }

    public void clear() {
        this.uniqueFields.clear();
        super.clear();
    }

    protected void addFieldOnce(String name, Object value) {
        Set existingValues = this.uniqueFields.computeIfAbsent(name, k -> {
            Collection fieldValues = this.getFieldValues(name);
            if (fieldValues != null) {
                return new HashSet(fieldValues);
            }
            return new HashSet();
        });
        if (existingValues.add(value)) {
            this.addField(name, value);
        }
    }

    public void addField(String name, Object value) {
        this.uniqueFields.computeIfPresent(name, (k, existingValues) -> {
            existingValues.add(value);
            return existingValues;
        });
        super.addField(name, value);
    }
}

