/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.EntityType;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.SolrEntityMetadataExtractor;

@Component(roles={SolrMetadataExtractorUtils.class})
@Singleton
public class SolrMetadataExtractorUtils {
    @Inject
    private ComponentManagerManager componentManagerManager;
    @Inject
    private ComponentManager defaultComponentManager;
    @Inject
    private Logger logger;

    public boolean extract(EntityReference reference, Object entity, SolrInputDocument solrDocument) {
        DefaultParameterizedType type = new DefaultParameterizedType(null, SolrEntityMetadataExtractor.class, new Type[]{entity.getClass()});
        EntityReference wikiReference = reference.extractReference(EntityType.WIKI);
        ComponentManager namespaceComponentManager = this.componentManagerManager.getComponentManager(new WikiNamespace(wikiReference.getName()).serialize(), false);
        if (namespaceComponentManager == null) {
            namespaceComponentManager = this.defaultComponentManager;
        }
        boolean updated = false;
        try {
            for (SolrEntityMetadataExtractor extractor : namespaceComponentManager.getInstanceList((Type)type)) {
                updated |= extractor.extract(entity, solrDocument);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to retrieve SolrEntityMetadataExtractor instances for type [{}]", (Object)type, (Object)e);
        }
        return updated;
    }
}

