/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.search.solr.internal.api.FieldUtils;
import org.xwiki.search.solr.internal.api.SolrFieldNameEncoder;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;
import org.xwiki.search.solr.internal.metadata.TypedValue;
import org.xwiki.search.solr.internal.metadata.XWikiSolrInputDocument;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Named(value="document")
@Singleton
public class DocumentSolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer renderer;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private UserReferenceSerializer<String> userReferenceSerializer;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> documentReferenceUserReferenceSerializer;
    @Inject
    @Named(value="solr")
    private EntityReferenceSerializer<String> fieldNameSerializer;
    @Inject
    private SolrFieldNameEncoder fieldNameEncoder;

    @Override
    public boolean setFieldsInternal(XWikiSolrInputDocument solrDocument, EntityReference entityReference) throws Exception {
        DocumentReference documentReference = new DocumentReference(entityReference);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument translatedDocument = this.getTranslatedDocument(documentReference);
        if (translatedDocument == null) {
            return false;
        }
        Locale locale = this.getLocale(documentReference);
        solrDocument.setField("fullname", this.localSerializer.serialize((EntityReference)documentReference, new Object[0]));
        String plainTitle = translatedDocument.getRenderedTitle(Syntax.PLAIN_1_0, xcontext);
        solrDocument.setField(FieldUtils.getFieldName("title", locale), plainTitle);
        solrDocument.setField(FieldUtils.getFieldName("doccontentraw", locale), translatedDocument.getContent());
        DefaultWikiPrinter plainContentPrinter = new DefaultWikiPrinter();
        this.renderer.render((Block)translatedDocument.getXDOM(), (WikiPrinter)plainContentPrinter);
        solrDocument.setField(FieldUtils.getFieldName("doccontent", locale), plainContentPrinter.toString());
        solrDocument.setField("version", translatedDocument.getVersion());
        solrDocument.setField("comment", translatedDocument.getComment());
        solrDocument.setField("doclocale", translatedDocument.getLocale().toString());
        this.addLocales(translatedDocument, translatedDocument.getLocale(), solrDocument);
        this.setAuthors(solrDocument, translatedDocument);
        solrDocument.setField("creationdate", translatedDocument.getCreationDate());
        solrDocument.setField("date", translatedDocument.getDate());
        solrDocument.setField("hidden", translatedDocument.isHidden());
        this.setLinks(solrDocument, translatedDocument, xcontext);
        this.setExtras(documentReference, solrDocument, locale);
        this.extractorUtils.extract((EntityReference)documentReference, translatedDocument, solrDocument);
        return true;
    }

    private void setAuthors(SolrInputDocument solrDocument, XWikiDocument translatedDocument) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentAuthors authors = translatedDocument.getAuthors();
        UserReference originalAuthor = authors.getOriginalMetadataAuthor();
        String authorString = (String)this.userReferenceSerializer.serialize(originalAuthor);
        solrDocument.setField("author", (Object)authorString);
        String authorDisplayString = xcontext.getWiki().getPlainUserName((DocumentReference)this.documentReferenceUserReferenceSerializer.serialize(originalAuthor), xcontext);
        solrDocument.setField("author_display", (Object)authorDisplayString);
        UserReference creator = authors.getCreator();
        String creatorString = (String)this.userReferenceSerializer.serialize(creator);
        solrDocument.setField("creator", (Object)creatorString);
        String creatorDisplayString = xcontext.getWiki().getPlainUserName((DocumentReference)this.documentReferenceUserReferenceSerializer.serialize(creator), xcontext);
        solrDocument.setField("creator_display", (Object)creatorDisplayString);
    }

    private void setLinks(SolrInputDocument solrDocument, XWikiDocument translatedDocument, XWikiContext xcontext) {
        Set references = translatedDocument.getUniqueLinkedEntities(xcontext);
        if (!references.isEmpty()) {
            HashSet<String> links = new HashSet<String>(references.size());
            HashSet<String> linksExtended = new HashSet<String>(references.size() * 2);
            for (EntityReference reference : references) {
                String referenceString = this.linkSerializer.serialize(reference);
                links.add(referenceString);
                linksExtended.add(referenceString);
                this.extendLink(reference, linksExtended);
            }
            for (String link : links) {
                solrDocument.addField("links", (Object)link);
            }
            for (String linkExtended : linksExtended) {
                solrDocument.addField("links_extended", (Object)linkExtended);
            }
        }
    }

    protected void setExtras(DocumentReference documentReference, XWikiSolrInputDocument solrDocument, Locale locale) throws XWikiException {
        XWikiDocument originalDocument = this.getDocument(documentReference);
        this.setObjects(solrDocument, locale, originalDocument);
        this.setAttachments(solrDocument, locale, originalDocument);
    }

    protected void setObjects(XWikiSolrInputDocument solrDocument, Locale locale, XWikiDocument originalDocument) {
        for (Map.Entry objects : originalDocument.getXObjects().entrySet()) {
            boolean hasObjectsOfThisType = false;
            for (BaseObject object : (List)objects.getValue()) {
                hasObjectsOfThisType |= object != null;
                this.setObjectContent(solrDocument, object, locale);
            }
            if (!hasObjectsOfThisType) continue;
            solrDocument.addField("class", this.localSerializer.serialize((EntityReference)objects.getKey(), new Object[0]));
        }
    }

    @Override
    protected void setPropertyValue(XWikiSolrInputDocument solrDocument, BaseProperty<?> property, TypedValue typedValue, Locale locale) {
        Object value = typedValue.getValue();
        String type = typedValue.getType();
        EntityReference classReference = property.getObject().getRelativeXClassReference();
        EntityReference propertyReference = new EntityReference(property.getName(), EntityType.CLASS_PROPERTY, classReference);
        String serializedPropertyReference = this.fieldNameEncoder.encode((String)this.fieldNameSerializer.serialize(propertyReference, new Object[0]));
        String prefix = "property." + serializedPropertyReference;
        solrDocument.addField(FieldUtils.getFieldName(prefix, type, locale), value);
        if (type != TypedValue.TEXT && type != "string" || String.valueOf(value).length() <= this.getShortTextLimit()) {
            String sortType = "sort" + StringUtils.capitalize((String)(type == TypedValue.TEXT ? "string" : type));
            solrDocument.setField(FieldUtils.getFieldName(prefix, sortType, locale), value);
        }
        String serializedClassReference = this.fieldNameEncoder.encode((String)this.fieldNameSerializer.serialize(classReference, new Object[0]));
        String objectOfTypeFieldName = "object." + serializedClassReference;
        this.addFieldValueOnce(solrDocument, FieldUtils.getFieldName(objectOfTypeFieldName, locale), value);
        super.setPropertyValue(solrDocument, property, typedValue, locale);
    }

    private void setAttachments(SolrInputDocument solrDocument, Locale locale, XWikiDocument originalDocument) {
        for (XWikiAttachment attachment : originalDocument.getAttachmentList()) {
            this.setAttachment(solrDocument, locale, attachment);
        }
    }

    private void setAttachment(SolrInputDocument solrDocument, Locale locale, XWikiAttachment attachment) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        solrDocument.addField("filename", (Object)attachment.getFilename());
        solrDocument.addField("mimetype", (Object)attachment.getMimeType(xcontext));
        solrDocument.addField("attdate", (Object)attachment.getDate());
        solrDocument.addField("attsize", (Object)attachment.getLongSize());
        String attachmentTextContent = this.getContentAsText(attachment);
        solrDocument.addField(FieldUtils.getFieldName("attcontent", locale), (Object)attachmentTextContent);
        String authorStringReference = (String)this.entityReferenceSerializer.serialize((EntityReference)attachment.getAuthorReference(), new Object[0]);
        solrDocument.addField("attauthor", (Object)authorStringReference);
        try {
            String authorDisplayName = xcontext.getWiki().getPlainUserName(attachment.getAuthorReference(), xcontext);
            solrDocument.addField("attauthor_display", (Object)authorDisplayName);
        }
        catch (Exception e) {
            this.logger.error("Failed to get author display name for attachment [{}]", (Object)attachment.getReference(), (Object)e);
        }
    }
}

