/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.xwiki.component.annotation.Component;
import org.xwiki.link.LinkException;
import org.xwiki.link.LinkStore;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractEntityReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.PageReference;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;
import org.xwiki.search.solr.internal.SolrSearchCoreUtils;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.search.solr.internal.metadata.SolrLinkSerializer;
import org.xwiki.store.ReadyIndicator;

@Component
@Singleton
public class DefaultLinkStore
implements LinkStore {
    private static final int ROWS = 1000;
    @Inject
    private Solr solr;
    @Inject
    private SolrUtils utils;
    @Inject
    private SolrSearchCoreUtils searchUtils;
    @Inject
    private SolrLinkSerializer linkSerializer;
    @Inject
    private SolrIndexer solrIndexer;
    @Inject
    private EntityReferenceResolver<EntityReference> referenceConverter;
    @Inject
    @Named(value="withparameters")
    private EntityReferenceResolver<String> referenceResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<PageReference> currentDocumentResolver;

    private SolrClient getClient() throws LinkException {
        try {
            return this.solr.getClient("search");
        }
        catch (SolrException e) {
            throw new LinkException("Failed to acces Solr search core", (Throwable)e);
        }
    }

    public Set<EntityReference> resolveLinkedEntities(EntityReference target) throws LinkException {
        SolrDocument solrDocument;
        String solrID;
        try {
            solrID = this.searchUtils.getId(target);
        }
        catch (Exception e) {
            throw new LinkException("Failed to serialize the Solr id for the reference [" + String.valueOf(target) + "]", (Throwable)e);
        }
        try {
            solrDocument = this.getClient().getById(solrID);
        }
        catch (Exception e) {
            throw new LinkException("Failed to load the Solr document for the reference [" + String.valueOf(target) + "] (id [" + solrID + "])", (Throwable)e);
        }
        if (solrDocument == null) {
            return Collections.emptySet();
        }
        Collection links = solrDocument.getFieldValues("links");
        HashSet<EntityReference> entities = new HashSet<EntityReference>(links.size());
        for (Object link : links) {
            EntityReference entityLink;
            if (!(link instanceof String) || (entityLink = this.linkSerializer.unserialize((String)link)) == null) continue;
            EntityReference documentLink = this.toDocumentBasedReference(entityLink);
            entities.add(documentLink);
        }
        return entities;
    }

    public Set<EntityReference> resolveBackLinkedEntities(EntityReference reference) throws LinkException {
        QueryResponse response;
        EntityReference pageBasedReference = this.toPageBasedReference(reference);
        EntityReference documentBasedReference = this.toDocumentBasedReference(reference);
        StringBuilder filter = new StringBuilder();
        if (pageBasedReference != null) {
            filter.append("links_extended");
            filter.append(':');
            filter.append(this.utils.toCompleteFilterQueryString(this.linkSerializer.serialize(pageBasedReference)));
            filter.append(" OR ");
        }
        filter.append("links_extended");
        filter.append(':');
        filter.append(this.utils.toCompleteFilterQueryString(this.linkSerializer.serialize(documentBasedReference)));
        SolrQuery solrQuery = new SolrQuery(filter.toString());
        solrQuery.setRows(Integer.valueOf(1000));
        solrQuery.addSort("id", SolrQuery.ORDER.asc);
        solrQuery.set("cursorMark", new String[]{"*"});
        solrQuery.setFields(new String[]{"reference"});
        HashSet<EntityReference> references = new HashSet<EntityReference>();
        do {
            try {
                response = this.getClient().query((SolrParams)solrQuery);
            }
            catch (Exception e) {
                throw new LinkException("Failed to search Solr for the backlinks of an entity", (Throwable)e);
            }
            SolrDocumentList solrDocuments = response.getResults();
            for (SolrDocument solrDocument : solrDocuments) {
                String referenceStr = (String)solrDocument.getFieldValue("reference");
                if (referenceStr == null) continue;
                references.add(this.referenceResolver.resolve((Object)referenceStr, null, new Object[0]));
            }
            solrQuery.set("cursorMark", new String[]{response.getNextCursorMark()});
        } while (response.getResults().size() == 1000);
        return references;
    }

    public ReadyIndicator waitReady() {
        return this.solrIndexer.waitReady();
    }

    EntityReference toDocumentBasedReference(EntityReference entityReference) {
        EntityReference pageReference = entityReference.extractReference(EntityType.PAGE);
        if (pageReference == null) {
            return entityReference;
        }
        if (entityReference.getType() == EntityType.PAGE) {
            return this.currentDocumentResolver.resolve((Object)(pageReference instanceof PageReference ? (PageReference)pageReference : new PageReference(pageReference)), new Object[0]);
        }
        EntityType documentBasedType = (EntityType)AbstractEntityReferenceResolver.TYPE_CONVERT_MAPPING.get(entityReference.getType());
        EntityReference documentBasedReference = this.referenceConverter.resolve((Object)entityReference, documentBasedType, new Object[0]);
        DocumentReference documentReference = this.currentDocumentResolver.resolve((Object)(pageReference instanceof PageReference ? (PageReference)pageReference : new PageReference(pageReference)), new Object[0]);
        return documentBasedReference.replaceParent(documentBasedReference.extractReference(EntityType.DOCUMENT), (EntityReference)documentReference);
    }

    EntityReference toPageBasedReference(EntityReference entityReference) {
        EntityReference documentBasedReference;
        if (entityReference.extractReference(EntityType.PAGE) != null) {
            return entityReference;
        }
        EntityType documentBasedType = entityReference.getType() == EntityType.DOCUMENT ? EntityType.PAGE : (EntityType)AbstractEntityReferenceResolver.TYPE_CONVERT_MAPPING.get(entityReference.getType());
        EntityReference pageBasedReference = this.referenceConverter.resolve((Object)entityReference, documentBasedType, new Object[0]);
        if (entityReference.extractReference(EntityType.DOCUMENT) != null && !(documentBasedReference = this.toDocumentBasedReference(pageBasedReference)).equals((Object)entityReference)) {
            return null;
        }
        return pageBasedReference;
    }
}

