/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.job;

import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.model.internal.reference.DefaultSymbolScheme;
import org.xwiki.model.internal.reference.LocalStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.search.solr.internal.job.AbstractDocumentIterator;
import org.xwiki.search.solr.internal.job.DocumentIterator;

public class DiffDocumentIterator<T>
extends AbstractDocumentIterator<Action> {
    private final DocumentIterator<T> previous;
    private final DocumentIterator<T> next;
    private final Comparator<DocumentReference> documentReferenceComparator = DiffDocumentIterator.getComparator();
    private Pair<DocumentReference, T> previousEntry;
    private Pair<DocumentReference, T> nextEntry;
    private int diff;

    public DiffDocumentIterator(DocumentIterator<T> previous, DocumentIterator<T> next) {
        this.previous = previous;
        this.next = next;
    }

    @Override
    public void setRootReference(EntityReference rootReference) {
        this.previous.setRootReference(rootReference);
        this.next.setRootReference(rootReference);
    }

    @Override
    public boolean hasNext() {
        return this.previous.hasNext() || this.next.hasNext();
    }

    @Override
    public Pair<DocumentReference, Action> next() {
        Action action;
        DocumentReference documentReference;
        if (this.next.hasNext() && this.previous.hasNext()) {
            if (this.diff >= 0) {
                this.nextEntry = (Pair)this.next.next();
            }
            if (this.diff <= 0) {
                this.previousEntry = (Pair)this.previous.next();
            }
            this.diff = this.documentReferenceComparator.compare((DocumentReference)this.previousEntry.getKey(), (DocumentReference)this.nextEntry.getKey());
            if (this.diff == 0) {
                documentReference = (DocumentReference)this.nextEntry.getKey();
                action = this.nextEntry.getValue().equals(this.previousEntry.getValue()) ? Action.SKIP : Action.UPDATE;
            } else if (this.diff > 0) {
                documentReference = (DocumentReference)this.nextEntry.getKey();
                action = Action.ADD;
            } else {
                documentReference = (DocumentReference)this.previousEntry.getKey();
                action = Action.DELETE;
            }
        } else if (this.next.hasNext()) {
            documentReference = (DocumentReference)((Pair)this.next.next()).getKey();
            action = Action.ADD;
        } else {
            documentReference = (DocumentReference)((Pair)this.previous.next()).getKey();
            action = Action.DELETE;
        }
        return new ImmutablePair((Object)documentReference, (Object)action);
    }

    public static Comparator<DocumentReference> getComparator() {
        LocalStringEntityReferenceSerializer localEntityReferenceSerializer = new LocalStringEntityReferenceSerializer((SymbolScheme)new DefaultSymbolScheme());
        return Comparator.comparing(DocumentReference::getWikiReference).thenComparing(arg_0 -> DiffDocumentIterator.lambda$getComparator$0((EntityReferenceSerializer)localEntityReferenceSerializer, arg_0)).thenComparing(EntityReference::getName).thenComparing(documentReference -> Objects.toString(documentReference.getLocale(), ""));
    }

    @Override
    public long size() {
        return Math.max(this.previous.size(), this.next.size());
    }

    private static /* synthetic */ String lambda$getComparator$0(EntityReferenceSerializer localEntityReferenceSerializer, DocumentReference documentReference) {
        return (String)localEntityReferenceSerializer.serialize(documentReference.getParent(), new Object[0]);
    }

    public static enum Action {
        SKIP,
        ADD,
        DELETE,
        UPDATE;

    }
}

