/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component(roles={SolrSearchCoreUtils.class})
@Singleton
public class SolrSearchCoreUtils {
    @Inject
    private ComponentManager componentManager;

    public SolrReferenceResolver getResolver(EntityReference entityReference) throws SolrIndexerException {
        try {
            return (SolrReferenceResolver)this.componentManager.getInstance(SolrReferenceResolver.class, entityReference.getType().getLowerCase());
        }
        catch (ComponentLookupException e) {
            throw new SolrIndexerException("Faile to find solr reference resolver for type reference [" + String.valueOf(entityReference) + "]");
        }
    }

    public String getId(EntityReference entityReference) throws SolrIndexerException, IllegalArgumentException {
        return this.getResolver(entityReference).getId(entityReference);
    }
}

