/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.xwiki.store.ReadyIndicator;

class SolrIndexerReadyIndicator
extends CompletableFuture<Void>
implements ReadyIndicator {
    private final long initialResolveQueueCounter;
    private final long initialResolveQueueSize;
    private final AtomicLong initialIndexQueueCounter;
    private final AtomicLong initialIndexQueueSize;
    private final LongSupplier resolveQueueCounter;
    private final LongSupplier indexQueueCounter;
    private final IntSupplier indexQueueSize;
    private final int resolveQueuePercentage;

    SolrIndexerReadyIndicator(LongSupplier resolveQueueCounter, IntSupplier resolveQueueSize, LongSupplier indexQueueCounter, IntSupplier indexQueueSize, IntSupplier indexQueueLimit) {
        this.resolveQueueCounter = resolveQueueCounter;
        this.indexQueueCounter = indexQueueCounter;
        this.indexQueueSize = indexQueueSize;
        int indexQueueSizeValue = indexQueueSize.getAsInt();
        this.initialResolveQueueCounter = resolveQueueCounter.getAsLong();
        this.initialResolveQueueSize = Math.max(resolveQueueSize.getAsInt(), 1);
        this.initialIndexQueueCounter = new AtomicLong(-1L);
        this.initialIndexQueueSize = new AtomicLong(-1L);
        this.resolveQueuePercentage = (double)indexQueueSizeValue >= 0.9 * (double)indexQueueLimit.getAsInt() || this.initialResolveQueueSize > 1L ? 50 : 10;
    }

    void switchToIndexQueue() {
        this.initialIndexQueueCounter.set(this.indexQueueCounter.getAsLong());
        this.initialIndexQueueSize.set(Math.max(this.indexQueueSize.getAsInt(), 1));
    }

    public int getProgressPercentage() {
        long initialIndexQueueSizeValue = this.initialIndexQueueSize.get();
        if (initialIndexQueueSizeValue < 0L) {
            long currentResolveQueueCounterValue = this.resolveQueueCounter.getAsLong();
            long removedElements = currentResolveQueueCounterValue - this.initialResolveQueueCounter;
            return Math.min(this.resolveQueuePercentage, (int)(removedElements * (long)this.resolveQueuePercentage / this.initialResolveQueueSize));
        }
        long currentIndexQueueCounterValue = this.indexQueueCounter.getAsLong();
        long removedElements = currentIndexQueueCounterValue - this.initialIndexQueueCounter.get();
        return Math.min(99, this.resolveQueuePercentage + (int)(removedElements * (long)(100 - this.resolveQueuePercentage) / initialIndexQueueSizeValue));
    }
}

