/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.search.solr.internal.api.SolrConfiguration;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.job.IndexerRequest;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="solr.initializer")
@Singleton
public class SolrIndexInitializeListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ApplicationReadyEvent(), new WikiReadyEvent());
    private static final List<String> REQUEST_DEFAULT_ID = Arrays.asList("solr", "indexer");
    @Inject
    protected Logger logger;
    @Inject
    private Provider<SolrIndexer> solrIndexer;
    @Inject
    private SolrConfiguration configuration;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.configuration.synchronizeAtStartup()) {
            SolrConfiguration.SynchronizeAtStartupMode startupMode = this.configuration.synchronizeAtStartupMode();
            IndexerRequest request = null;
            ArrayList<String> requestId = new ArrayList<String>(REQUEST_DEFAULT_ID);
            try {
                if (event instanceof ApplicationReadyEvent) {
                    if (startupMode == SolrConfiguration.SynchronizeAtStartupMode.FARM) {
                        request = new IndexerRequest();
                        request.setId(requestId);
                    } else if (startupMode == SolrConfiguration.SynchronizeAtStartupMode.WIKI) {
                        request = new IndexerRequest();
                        WikiReference wikiReference = this.wikiDescriptorManager.getMainWikiDescriptor().getReference();
                        request.setRootReference((EntityReference)wikiReference);
                        requestId.add((String)this.entityReferenceSerializer.serialize((EntityReference)wikiReference, new Object[0]));
                        request.setId(requestId);
                    }
                } else if (startupMode == SolrConfiguration.SynchronizeAtStartupMode.WIKI && event instanceof WikiReadyEvent) {
                    WikiReadyEvent wikiReadyEvent = (WikiReadyEvent)event;
                    WikiReference wikiReference = new WikiReference(wikiReadyEvent.getWikiId());
                    request = new IndexerRequest();
                    request.setRootReference((EntityReference)wikiReference);
                    requestId.add((String)this.entityReferenceSerializer.serialize((EntityReference)wikiReference, new Object[0]));
                    request.setId(requestId);
                }
                if (request != null) {
                    ((SolrIndexer)this.solrIndexer.get()).startIndex(request);
                }
            }
            catch (SolrIndexerException | WikiManagerException e) {
                this.logger.error("Failed to start initial Solr index synchronization", e);
            }
        }
    }
}

