/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.NamedList;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.internal.AbstractSolr;
import org.xwiki.search.solr.internal.DefaultXWikiSolrCore;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Named(value="remote")
@Singleton
public class RemoteSolr
extends AbstractSolr
implements Initializable {
    public static final String TYPE = "remote";
    public static final String DEFAULT_BASE_URL = "http://localhost:8983/solr";
    public static final String DEFAULT_CORE_PREFIX = "xwiki";
    private static final boolean REQUEST_VERSION = Boolean.parseBoolean(System.getProperty("xwiki.solr.remote.requestVersion", "true"));
    @Inject
    private SolrConfiguration configuration;
    private HttpSolrClient rootClient;
    private int solrMajorVersion;

    public void initialize() throws InitializationException {
        String baseURL = this.configuration.getInstanceConfiguration(TYPE, "baseURL", null);
        String searchCoreURL = this.configuration.getInstanceConfiguration(TYPE, "url", null);
        if (searchCoreURL != null) {
            this.cores.put("search", new DefaultXWikiSolrCore("search", this.toSolrCoreName("search"), (SolrClient)new HttpSolrClient.Builder(searchCoreURL).build()));
            if (baseURL == null) {
                baseURL = searchCoreURL.substring(0, searchCoreURL.lastIndexOf(47));
                this.logger.warn("[solr.remote.url] property in xwiki.properties file is deprecated, use [solr.remote.baseURL] instead");
            }
        }
        if (baseURL == null) {
            baseURL = DEFAULT_BASE_URL;
        }
        this.rootClient = new HttpSolrClient.Builder(baseURL).build();
        if (REQUEST_VERSION) {
            NamedList systemInfo;
            try {
                systemInfo = this.rootClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system"));
            }
            catch (Exception e) {
                throw new InitializationException("Failed to access the Solr server information", (Throwable)e);
            }
            String version = (String)systemInfo.findRecursive(new String[]{"lucene", "solr-impl-version"});
            if (version != null) {
                this.solrMajorVersion = Integer.parseInt(StringUtils.substringBefore((String)version, (int)46));
            } else {
                throw new InitializationException("The Solr server does not give any information about its version in lucene -> solr-impl-version. Received [" + String.valueOf(systemInfo) + "].");
            }
        }
    }

    private Set<String> getCores() throws SolrServerException, IOException {
        CoreAdminRequest request = new CoreAdminRequest();
        request.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        CoreAdminResponse response = (CoreAdminResponse)request.process((SolrClient)this.rootClient);
        HashSet<String> cores = new HashSet<String>();
        for (int i = 0; i < response.getCoreStatus().size(); ++i) {
            cores.add(response.getCoreStatus().getName(i));
        }
        return cores;
    }

    HttpSolrClient getRootClient() {
        return this.rootClient;
    }

    @Override
    protected int getSolrMajorVersion() {
        return this.solrMajorVersion;
    }

    @Override
    protected SolrClient getInternalSolrClient(String solrCoreName) throws SolrException {
        try {
            if (this.getCores().contains(solrCoreName)) {
                return new HttpSolrClient.Builder(this.getRootClient().getBaseURL() + "/" + solrCoreName).build();
            }
        }
        catch (Exception e) {
            throw new SolrException("Failed to get the list of cores", e);
        }
        return null;
    }

    private String getCorePrefix() {
        return this.configuration.getInstanceConfiguration(TYPE, "corePrefix", DEFAULT_CORE_PREFIX);
    }

    @Override
    protected String toSolrCoreName(String xwikiCoreName, int majorVersion) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCorePrefix());
        if (majorVersion > 8 || !xwikiCoreName.equals("search")) {
            builder.append('_');
            builder.append(super.toSolrCoreName(xwikiCoreName, majorVersion));
        }
        return builder.toString();
    }

    @Override
    protected String toXWikiCoreName(String solrCoreName) {
        String prefixedCoreName = super.toXWikiCoreName(solrCoreName);
        return Strings.CS.removeStart(prefixedCoreName, (CharSequence)this.getCorePrefix());
    }

    @Override
    protected SolrClient createSolrClient(String solrCoreName, boolean isCache) throws SolrException {
        CoreAdminRequest.Create coreAdminRequest = new CoreAdminRequest.Create();
        coreAdminRequest.setCoreName(solrCoreName);
        try {
            coreAdminRequest.process((SolrClient)this.getRootClient());
        }
        catch (Exception e) {
            throw new SolrException("Failed to create a new core", e);
        }
        return this.getInternalSolrClient(solrCoreName);
    }
}

