/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.util.AbstractXWikiRunnable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.internal.DocumentContextExecutor;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.DisposePriority;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.index.IndexException;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.IndexOperation;
import org.xwiki.search.solr.internal.SolrIndexerReadyIndicator;
import org.xwiki.search.solr.internal.api.IndexingUserConfig;
import org.xwiki.search.solr.internal.api.SolrConfiguration;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.api.SolrInstance;
import org.xwiki.search.solr.internal.job.IndexerJob;
import org.xwiki.search.solr.internal.job.IndexerRequest;
import org.xwiki.search.solr.internal.metadata.SolrMetadataExtractor;
import org.xwiki.search.solr.internal.metadata.XWikiSolrInputDocument;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;
import org.xwiki.store.ReadyIndicator;

@Component
@Singleton
@DisposePriority(value=500)
public class DefaultSolrIndexer
implements SolrIndexer,
Initializable,
Disposable,
Runnable {
    private static final ResolveQueueEntry RESOLVE_QUEUE_ENTRY_STOP = new ResolveQueueEntry(null, false, IndexOperation.STOP);
    private static final IndexQueueEntry INDEX_QUEUE_ENTRY_STOP = new IndexQueueEntry((String)null, IndexOperation.STOP);
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private SolrConfiguration configuration;
    @Inject
    private SolrInstance solrInstance;
    @Inject
    private SolrReferenceResolver solrRefereceResolver;
    @Inject
    private IndexingUserConfig indexingUserConfig;
    @Inject
    private Execution execution;
    @Inject
    private ExecutionContextManager ecim;
    @Inject
    private JobExecutor jobs;
    @Inject
    private DocumentContextExecutor documentContextExecutor;
    @Inject
    private Provider<XWikiContext> xWikiContextProvider;
    private BlockingQueue<IndexQueueEntry> indexQueue;
    private BlockingQueue<ResolveQueueEntry> resolveQueue;
    private Thread indexThread;
    private Thread resolveThread;
    private final AtomicLong indexQueueRemovalCounter = new AtomicLong();
    private final AtomicLong resolveQueueRemovalCounter = new AtomicLong();
    private boolean disposed;
    private volatile int batchSize;

    public void initialize() throws InitializationException {
        this.resolveQueue = new LinkedBlockingQueue<ResolveQueueEntry>();
        this.indexQueue = new LinkedBlockingQueue<IndexQueueEntry>(this.configuration.getIndexerQueueCapacity());
        this.resolveThread = new Thread((Runnable)((Object)new Resolver()));
        this.resolveThread.setName("XWiki Solr resolve thread");
        this.resolveThread.setDaemon(true);
        this.resolveThread.start();
        this.resolveThread.setPriority(4);
        this.indexThread = new Thread(this);
        this.indexThread.setName("XWiki Solr index thread");
        this.indexThread.setDaemon(true);
        this.indexThread.start();
        this.indexThread.setPriority(4);
    }

    public void dispose() throws ComponentLifecycleException {
        this.disposed = true;
        ResolveQueueEntry entry = (ResolveQueueEntry)this.resolveQueue.poll();
        while (entry != null) {
            if (entry.operation == IndexOperation.READY_MARKER && entry.readyIndicator != null) {
                entry.readyIndicator.completeExceptionally((Throwable)new IndexException("Indexing stopped."));
            }
            entry = (ResolveQueueEntry)this.resolveQueue.poll();
        }
        this.resolveQueue.offer(RESOLVE_QUEUE_ENTRY_STOP);
        this.stopIndexerThread();
    }

    private void stopIndexerThread() {
        IndexQueueEntry entry = (IndexQueueEntry)this.indexQueue.poll();
        while (entry != null) {
            if (entry.operation == IndexOperation.READY_MARKER && entry.readyIndicator != null) {
                entry.readyIndicator.completeExceptionally((Throwable)new IndexException("Indexing stopped."));
            }
            entry = (IndexQueueEntry)this.indexQueue.poll();
        }
        this.indexQueue.offer(INDEX_QUEUE_ENTRY_STOP);
    }

    @Override
    public void run() {
        this.logger.debug("Start SOLR indexer thread");
        while (!Thread.interrupted()) {
            IndexQueueEntry queueEntry = null;
            try {
                queueEntry = this.indexQueue.take();
            }
            catch (InterruptedException e) {
                this.logger.warn("The SOLR index thread has been interrupted", (Throwable)e);
                queueEntry = INDEX_QUEUE_ENTRY_STOP;
            }
            if (this.processBatch(queueEntry)) continue;
            break;
        }
        this.logger.debug("Stop SOLR indexer thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean processBatch(IndexQueueEntry queueEntry) {
        length = 0;
        batchEntry = queueEntry;
        while (batchEntry != null) {
            this.indexQueueRemovalCounter.incrementAndGet();
            if (batchEntry == DefaultSolrIndexer.INDEX_QUEUE_ENTRY_STOP) {
                return false;
            }
            operation = batchEntry.operation;
            try {
                executionContext = new ExecutionContext();
                this.ecim.initialize(executionContext);
                xcontext = (XWikiContext)executionContext.getProperty("xwikicontext");
                xcontext.setUserReference(this.indexingUserConfig.getIndexingUserReference());
                switch (1.$SwitchMap$org$xwiki$search$solr$internal$IndexOperation[operation.ordinal()]) {
                    case 1: {
                        solrDocument = this.getSolrDocument(batchEntry.reference);
                        if (solrDocument == null) ** break;
                        this.solrInstance.add(solrDocument);
                        length += solrDocument.getLength();
                        ++this.batchSize;
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        this.applyDeletion(batchEntry);
                        ++this.batchSize;
                        ** break;
lbl27:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        this.commit();
                        batchEntry.readyIndicator.complete(null);
                        length = 0;
                        ** break;
lbl34:
                        // 1 sources

                        break;
                    }
                    ** default:
lbl36:
                    // 1 sources

                    break;
                }
            }
            catch (Throwable e) {
                this.logger.error("Failed to process entry [{}]", (Object)batchEntry, (Object)e);
            }
            finally {
                this.execution.removeContext();
            }
            if (this.shouldCommit(length, this.batchSize)) {
                this.commit();
                length = 0;
            }
            batchEntry = (IndexQueueEntry)this.indexQueue.poll();
        }
        if (this.batchSize > 0) {
            this.commit();
        }
        return true;
    }

    private void applyDeletion(IndexQueueEntry queueEntry) throws SolrServerException, IOException, SolrIndexerException {
        if (queueEntry.reference == null) {
            this.solrInstance.deleteByQuery(queueEntry.deleteQuery);
        } else {
            this.solrInstance.delete(this.solrRefereceResolver.getId(queueEntry.reference));
        }
    }

    private void commit() {
        try {
            this.solrInstance.commit();
        }
        catch (Exception e) {
            this.logger.error("Failed to commit index changes to the Solr server. Rolling back.", (Throwable)e);
            try {
                this.solrInstance.rollback();
            }
            catch (Exception ex) {
                this.logger.error("Failed to rollback index changes.", (Throwable)ex);
            }
        }
        this.batchSize = 0;
    }

    private boolean shouldCommit(int length, int size) {
        if (length >= this.configuration.getIndexerBatchMaxLengh()) {
            return true;
        }
        return size >= this.configuration.getIndexerBatchSize();
    }

    private XWikiSolrInputDocument getSolrDocument(EntityReference reference) throws SolrIndexerException, IllegalArgumentException, ExecutionContextException {
        SolrMetadataExtractor metadataExtractor = this.getMetadataExtractor(reference.getType());
        if (metadataExtractor != null) {
            XWikiContext context = (XWikiContext)this.xWikiContextProvider.get();
            try {
                XWikiDocument document = context.getWiki().getDocument(reference, context);
                return (XWikiSolrInputDocument)((Object)this.documentContextExecutor.call(() -> metadataExtractor.getSolrDocument(reference), (DocumentModelBridge)document));
            }
            catch (IllegalArgumentException | SolrIndexerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SolrIndexerException("Error executing the indexer in the context of the document to index", e);
            }
        }
        return null;
    }

    private SolrMetadataExtractor getMetadataExtractor(EntityType entityType) {
        SolrMetadataExtractor result = null;
        try {
            result = (SolrMetadataExtractor)this.componentManager.getInstance(SolrMetadataExtractor.class, entityType.name().toLowerCase());
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Unsupported entity type: [{}]", (Object)entityType.toString(), (Object)e);
        }
        return result;
    }

    @Override
    public void index(EntityReference reference, boolean recurse) {
        this.addToQueue(reference, recurse, IndexOperation.INDEX);
    }

    @Override
    public void delete(EntityReference reference, boolean recurse) {
        this.addToQueue(reference, recurse, IndexOperation.DELETE);
    }

    private void addToQueue(EntityReference reference, boolean recurse, IndexOperation operation) {
        if (!this.disposed) {
            try {
                this.resolveQueue.put(new ResolveQueueEntry(reference, recurse, operation));
            }
            catch (InterruptedException e) {
                this.logger.error("Failed to add reference [{}] to Solr indexing queue", (Object)reference, (Object)e);
            }
        }
    }

    @Override
    public int getQueueSize() {
        return this.indexQueue.size() + this.resolveQueue.size() + this.batchSize;
    }

    @Override
    public IndexerJob startIndex(IndexerRequest request) throws SolrIndexerException {
        try {
            return (IndexerJob)this.jobs.execute("solr.indexer", (Request)request);
        }
        catch (JobException e) {
            throw new SolrIndexerException("Failed to start index job", (Exception)((Object)e));
        }
    }

    @Override
    public ReadyIndicator waitReady() {
        SolrIndexerReadyIndicator readyIndicator = new SolrIndexerReadyIndicator(this.resolveQueueRemovalCounter::getAcquire, this.resolveQueue::size, this.indexQueueRemovalCounter::getAcquire, this.indexQueue::size, this.configuration::getIndexerQueueCapacity);
        if (!this.disposed) {
            try {
                this.resolveQueue.put(new ResolveQueueEntry(readyIndicator));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                readyIndicator.completeExceptionally(e);
            }
        } else {
            readyIndicator.completeExceptionally(new SolrIndexerException("The indexer has been disposed"));
        }
        return readyIndicator;
    }

    private final class Resolver
    extends AbstractXWikiRunnable {
        private Resolver() {
        }

        public void runInternal() {
            DefaultSolrIndexer.this.logger.debug("Start SOLR resolver thread");
            block6: while (!Thread.interrupted()) {
                ResolveQueueEntry queueEntry = this.getQueueEntry();
                if (queueEntry == RESOLVE_QUEUE_ENTRY_STOP) {
                    DefaultSolrIndexer.this.stopIndexerThread();
                    break;
                }
                try {
                    switch (queueEntry.operation) {
                        case READY_MARKER: {
                            queueEntry.readyIndicator.switchToIndexQueue();
                            DefaultSolrIndexer.this.indexQueue.put(new IndexQueueEntry(queueEntry.readyIndicator));
                            break;
                        }
                        case INDEX: {
                            Iterable<EntityReference> references = this.retrieveReferences(queueEntry);
                            for (EntityReference reference : references) {
                                DefaultSolrIndexer.this.indexQueue.put(new IndexQueueEntry(reference, queueEntry.operation));
                            }
                            continue block6;
                        }
                        default: {
                            if (queueEntry.recurse) {
                                DefaultSolrIndexer.this.indexQueue.put(new IndexQueueEntry(DefaultSolrIndexer.this.solrRefereceResolver.getQuery(queueEntry.reference), queueEntry.operation));
                                break;
                            }
                            if (queueEntry.reference == null) continue block6;
                            DefaultSolrIndexer.this.indexQueue.put(new IndexQueueEntry(queueEntry.reference, queueEntry.operation));
                        }
                    }
                }
                catch (Throwable e) {
                    DefaultSolrIndexer.this.logger.warn("Failed to apply operation [{}] on root reference [{}]", new Object[]{queueEntry.operation, queueEntry.reference, e});
                }
            }
            DefaultSolrIndexer.this.logger.debug("Stop SOLR resolver thread");
        }

        private Iterable<EntityReference> retrieveReferences(ResolveQueueEntry queueEntry) throws SolrIndexerException {
            Iterable<EntityReference> references = queueEntry.recurse ? DefaultSolrIndexer.this.solrRefereceResolver.getReferences(queueEntry.reference) : Arrays.asList(queueEntry.reference);
            return references;
        }

        private ResolveQueueEntry getQueueEntry() {
            ResolveQueueEntry queueEntry;
            try {
                queueEntry = DefaultSolrIndexer.this.resolveQueue.take();
                DefaultSolrIndexer.this.resolveQueueRemovalCounter.incrementAndGet();
            }
            catch (InterruptedException e) {
                DefaultSolrIndexer.this.logger.warn("The SOLR resolve thread has been interrupted", (Throwable)e);
                queueEntry = RESOLVE_QUEUE_ENTRY_STOP;
            }
            return queueEntry;
        }
    }

    private static class ResolveQueueEntry {
        public EntityReference reference;
        public boolean recurse;
        public IndexOperation operation;
        private final SolrIndexerReadyIndicator readyIndicator;

        public ResolveQueueEntry(EntityReference reference, boolean recurse, IndexOperation operation) {
            this.reference = reference;
            this.recurse = recurse;
            this.operation = operation;
            this.readyIndicator = null;
        }

        ResolveQueueEntry(SolrIndexerReadyIndicator readyIndicator) {
            this.readyIndicator = readyIndicator;
            this.operation = IndexOperation.READY_MARKER;
        }
    }

    private static class IndexQueueEntry {
        public EntityReference reference;
        public String deleteQuery;
        public IndexOperation operation;
        private SolrIndexerReadyIndicator readyIndicator;

        public IndexQueueEntry(EntityReference indexReference, IndexOperation operation) {
            this.reference = indexReference;
            this.operation = operation;
        }

        public IndexQueueEntry(String deleteQuery, IndexOperation operation) {
            this.deleteQuery = deleteQuery;
            this.operation = operation;
        }

        IndexQueueEntry(SolrIndexerReadyIndicator readyIndicator) {
            this.readyIndicator = readyIndicator;
            this.operation = IndexOperation.READY_MARKER;
        }

        public String toString() {
            return switch (this.operation) {
                case IndexOperation.INDEX -> "INDEX " + String.valueOf(this.reference);
                case IndexOperation.DELETE -> "DELETE " + this.deleteQuery;
                case IndexOperation.STOP -> "STOP";
                case IndexOperation.READY_MARKER -> "READY_MARKER";
                default -> "";
            };
        }
    }
}

