/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.ListClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.search.solr.internal.api.IndexingUserConfig;

@Component
@Singleton
public class DefaultIndexingUserConfig
implements IndexingUserConfig {
    static final LocalDocumentReference CONFIG_CLASS = new LocalDocumentReference("XWiki", "SolrSearchAdminIndexingUserClass");
    static final LocalDocumentReference CONFIG_PAGE = new LocalDocumentReference("XWiki", "SolrSearchAdminIndexingUser");
    static final String CONFIG_USER_ATTRIBUTE = "indexer";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> documentReferenceResolver;

    @Override
    public DocumentReference getIndexingUserReference() throws XWikiException {
        WikiReference mainWikiRef;
        DocumentReference indexingUser = null;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki wiki = context.getWiki();
        XWikiDocument configPage = wiki.getDocument(new DocumentReference(CONFIG_PAGE, mainWikiRef = new WikiReference(context.getMainXWiki())), context);
        BaseObject configObject = configPage.getXObject((EntityReference)CONFIG_CLASS);
        if (configObject != null) {
            String indexers = configObject.getLargeStringValue(CONFIG_USER_ATTRIBUTE);
            for (String userRef : ListClass.getListFromString((String)indexers)) {
                if (!StringUtils.isNotBlank((CharSequence)userRef)) continue;
                indexingUser = this.documentReferenceResolver.resolve((Object)userRef, new Object[]{mainWikiRef});
                break;
            }
        }
        return indexingUser;
    }
}

