/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.scheduler.AbstractJob;
import com.xpn.xwiki.web.Utils;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Objects;
import org.codehaus.groovy.control.CompilationFailedException;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class GroovyJob
extends AbstractJob {
    @Override
    protected void executeJob(JobExecutionContext jobContext) throws JobExecutionException {
        try {
            XWikiDocument secureDocument;
            JobDataMap data = jobContext.getJobDetail().getJobDataMap();
            BaseObject object = (BaseObject)data.get((Object)"xjob");
            XWikiDocument jobDocument = object.getOwnerDocument();
            if (jobDocument == null) {
                jobDocument = this.getXWikiContext().getWiki().getDocument(object.getDocumentReference(), this.getXWikiContext());
            }
            this.getXWikiContext().setDoc(jobDocument);
            if (!Objects.equals(jobDocument.getAuthors().getContentAuthor(), jobDocument.getAuthors().getEffectiveMetadataAuthor())) {
                secureDocument = jobDocument.clone();
                secureDocument.getAuthors().setContentAuthor(jobDocument.getAuthors().getEffectiveMetadataAuthor());
            } else {
                secureDocument = jobDocument;
            }
            this.getXWikiContext().put((Object)"sdoc", (Object)secureDocument);
            ContextualAuthorizationManager contextualAuthorizationManager = (ContextualAuthorizationManager)Utils.getComponent(ContextualAuthorizationManager.class);
            contextualAuthorizationManager.checkAccess(Right.PROGRAM);
            Binding binding = new Binding(data.getWrappedMap());
            binding.setProperty("context", (Object)this.getXWikiContext());
            binding.setProperty("xcontext", (Object)this.getXWikiContext());
            data.put("xwiki", (Object)new XWiki(this.getXWikiContext().getWiki(), this.getXWikiContext()));
            GroovyShell shell = new GroovyShell(Thread.currentThread().getContextClassLoader(), binding);
            shell.evaluate(object.getLargeStringValue("script"));
        }
        catch (CompilationFailedException e) {
            throw new JobExecutionException("Failed to execute script for job [" + String.valueOf(jobContext.getJobDetail().getKey()) + "]", (Throwable)e);
        }
        catch (XWikiException e) {
            throw new JobExecutionException("Failed to load the document containing the job [" + String.valueOf(jobContext.getJobDetail().getKey()) + "]", (Throwable)e);
        }
        catch (AccessDeniedException e) {
            throw new JobExecutionException("Executing the job [" + String.valueOf(jobContext.getJobDetail().getKey()) + "] failed due to insufficient rights.", (Throwable)e);
        }
    }
}

