/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.script;

import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.url.RestURLGenerator;
import org.xwiki.script.service.ScriptService;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="rest")
@Singleton
public class RESTScriptService
implements ScriptService {
    private static final String ERROR_KEY = "scriptservice.rest.error";
    @Inject
    private RestURLGenerator restURLGenerator;
    @Inject
    private Execution execution;
    @Inject
    private WikiDescriptorManager wikis;

    public String url(EntityReference reference) {
        return this.url(reference, false);
    }

    public String url(EntityReference reference, boolean external) {
        EntityReference wikiReference = reference.extractReference(EntityType.WIKI);
        try {
            URL externalURL = this.restURLGenerator.getURL(reference);
            if (external || wikiReference != null && !wikiReference.getName().equals(this.wikis.getCurrentWikiId())) {
                return externalURL.toExternalForm();
            }
            return externalURL.getPath();
        }
        catch (XWikiRestException e) {
            this.setLastError(e);
            return null;
        }
    }

    public XWikiRestException getLastError() {
        return (XWikiRestException)((Object)this.execution.getContext().getProperty(ERROR_KEY));
    }

    private void setLastError(XWikiRestException e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }
}

