/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.wikis;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.wikis.WikiPagesResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.wikis.WikiPagesResourceImpl")
public class WikiPagesResourceImpl
extends XWikiResource
implements WikiPagesResource {
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    public Pages getPages(String wikiName, Integer start, String name, String space, String author, Integer number) throws XWikiRestException {
        XWikiContext context = Utils.getXWikiContext(this.componentManager);
        WikiReference wikiReference = context.getWikiReference();
        context.setWikiReference(new WikiReference(wikiName));
        Pages pages = this.objectFactory.createPages();
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            if (!StringUtils.isEmpty((CharSequence)name)) {
                filters.put("name", name);
            }
            if (!StringUtils.isEmpty((CharSequence)space)) {
                filters.put("space", Utils.getLocalSpaceId(this.parseSpaceSegments(space)));
            }
            if (!StringUtils.isEmpty((CharSequence)author)) {
                filters.put("author", author);
            }
            StringBuilder stringBuilder = new StringBuilder("select doc from XWikiDocument as doc");
            if (!filters.isEmpty()) {
                stringBuilder.append(" where (");
                int i = 0;
                for (String param : filters.keySet()) {
                    if (param.equals("name")) {
                        stringBuilder.append("upper(doc.fullName) like :name ");
                    }
                    if (param.equals("space")) {
                        stringBuilder.append("upper(doc.space) like :space ");
                    }
                    if (param.equals("author")) {
                        stringBuilder.append("upper(doc.contentAuthor) like :author ");
                    }
                    if (++i >= filters.keySet().size()) continue;
                    stringBuilder.append("and ");
                }
                stringBuilder.append(")");
            }
            String queryString = stringBuilder.toString();
            List queryResult = null;
            Query query = this.queryManager.createQuery(queryString, "xwql").setWiki(wikiName).setLimit(this.validateAndGetLimit(number)).setOffset(start.intValue());
            for (Map.Entry filterEntry : filters.entrySet()) {
                query.bindValue((String)filterEntry.getKey(), (Object)String.format("%%%s%%", ((String)filterEntry.getValue()).toUpperCase()));
            }
            queryResult = query.execute();
            XWikiURLFactory urlFactory = context.getURLFactory();
            for (Object object : queryResult) {
                XWikiDocument xwikiDocument = (XWikiDocument)object;
                Document doc = new Document(xwikiDocument, context);
                if (!this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)doc.getDocumentReference())) continue;
                PageSummary pageSummary = this.objectFactory.createPageSummary();
                pageSummary.setId(doc.getPrefixedFullName());
                pageSummary.setFullName(doc.getFullName());
                pageSummary.setWiki(wikiName);
                pageSummary.setSpace(doc.getSpace());
                pageSummary.setName(doc.getDocumentReference().getName());
                pageSummary.setTitle(doc.getTitle());
                pageSummary.setParent(doc.getParent());
                URL absoluteUrl = urlFactory.createExternalURL(doc.getSpace(), doc.getDocumentReference().getName(), "view", null, null, context);
                pageSummary.setXwikiAbsoluteUrl(absoluteUrl.toString());
                pageSummary.setXwikiRelativeUrl(urlFactory.getURL(absoluteUrl, context));
                String pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageResource.class, doc.getWiki(), Utils.getSpacesURLElements((EntityReference)doc.getDocumentReference()), doc.getDocumentReference().getName()).toString();
                Link pageLink = this.objectFactory.createLink();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                pageSummary.getLinks().add(pageLink);
                pages.getPageSummaries().add(pageSummary);
            }
        }
        catch (QueryException e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            context.setWikiReference(wikiReference);
        }
        return pages;
    }
}

