/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.wikis;

import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.tree.PageHierarchy;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.resources.AbstractPagesResource;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.resources.wikis.WikiChildrenResource;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.wikis.WikiChildrenResourceImpl")
public class WikiChildrenResourceImpl
extends AbstractPagesResource
implements WikiChildrenResource {
    @Inject
    @Named(value="nestedpages")
    private PageHierarchy nestedPageHierarchy;

    public Pages getChildren(String wikiName, Integer offset, Integer limit, String search) throws XWikiRestException {
        WikiReference wikiReference = new WikiReference(wikiName);
        if (!this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)wikiReference)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        int queryLimit = this.validateAndGetLimit(limit);
        try {
            return this.getPages(this.nestedPageHierarchy.getChildren(wikiReference).withOffset(offset.intValue()).withLimit(queryLimit).matching(search).getDocumentReferences(), true);
        }
        catch (QueryException e) {
            throw new XWikiRestException("Failed to retrieve the top level pages.", (Throwable)e);
        }
    }
}

