/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.tags;

import com.xpn.xwiki.api.Document;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.resources.tags.PagesForTagsResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.tags.PagesForTagsResourceImpl")
public class PagesForTagsResourceImpl
extends XWikiResource
implements PagesForTagsResource {
    public Pages getTags(String wikiName, String tagNames, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        int limit = this.validateAndGetLimit(number);
        try {
            Pages pages = this.objectFactory.createPages();
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            String[] tagNamesArray = tagNames.split(",");
            List<String> documentNames = this.getDocumentsWithTags(tagNamesArray, start, limit);
            for (String documentName : documentNames) {
                Document doc = Utils.getXWikiApi(this.componentManager).getDocument(documentName);
                if (doc == null) continue;
                pages.getPageSummaries().add(DomainObjectFactory.createPageSummary(this.objectFactory, this.uriInfo.getBaseUri(), doc, Utils.getXWikiApi(this.componentManager), withPrettyNames));
            }
            Pages pages2 = pages;
            return pages2;
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    private List<String> getDocumentsWithTags(String[] tags, Integer start, Integer limit) throws QueryException {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("select distinct doc.fullName from XWikiDocument as doc, BaseObject as obj, DBStringListProperty as prop ");
        queryBuilder.append("where obj.name=doc.fullName and obj.className='XWiki.TagClass' and obj.id=prop.id.id ");
        queryBuilder.append("and prop.id.name='tags' and (");
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                queryBuilder.append(" or ");
            }
            queryBuilder.append(":tag").append(i).append(" in elements(prop.list)");
        }
        queryBuilder.append(") order by doc.fullName asc");
        Query query = this.queryManager.createQuery(queryBuilder.toString(), "hql").setLimit(limit.intValue()).setOffset(start.intValue());
        for (int i = 0; i < tags.length; ++i) {
            query.bindValue("tag" + i, (Object)tags[i].trim());
        }
        return query.execute();
    }
}

