/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.search;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.search.AbstractSearchSource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractDatabaseSearchSource
extends AbstractSearchSource {
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="secure")
    protected QueryManager queryManager;
    @Inject
    @Named(value="hidden/document")
    protected QueryFilter hiddenFilter;
    @Inject
    protected ModelFactory modelFactory;
    @Inject
    protected DocumentReferenceResolver<String> resolver;
    @Inject
    protected ContextualAuthorizationManager authorization;
    protected final String queryLanguage;

    public AbstractDatabaseSearchSource(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    protected abstract String resolveQuery(boolean var1, String var2);

    @Override
    public List<SearchResult> search(String partialQueryString, String wikiName, String wikis, boolean hasProgrammingRights, String orderField, String order, boolean distinct, int number, int start, Boolean withPrettyNames, String className, UriInfo uriInfo) throws Exception {
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwikiApi = new XWiki(xwikiContext.getWiki(), xwikiContext);
        if (partialQueryString == null || StringUtils.startsWithIgnoreCase((CharSequence)partialQueryString, (CharSequence)"select")) {
            return Collections.emptyList();
        }
        String queryString = this.resolveQuery(distinct, partialQueryString);
        Query query = this.queryManager.createQuery(queryString, this.queryLanguage);
        query.setLimit(number).setOffset(start);
        query.setWiki(wikiName);
        List queryResult = query.execute();
        WikiReference wikiReference = new WikiReference(wikiName);
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        for (Object object : queryResult) {
            String pageUri;
            XWikiDocument xdocument;
            BaseObject baseObject;
            Object[] fields = (Object[])object;
            String fullName = (String)fields[0];
            String language = (String)fields[3];
            DocumentReference documentReference = this.resolver.resolve((Object)fullName, new Object[]{wikiReference});
            if (!this.authorization.hasAccess(Right.VIEW, (EntityReference)documentReference)) continue;
            Document doc = xwikiApi.getDocument(documentReference);
            String title = doc.getDisplayTitle();
            SearchResult searchResult = this.objectFactory.createSearchResult();
            searchResult.setType("page");
            searchResult.setId(doc.getPrefixedFullName());
            searchResult.setPageFullName(doc.getFullName());
            searchResult.setTitle(title);
            searchResult.setWiki(wikiName);
            searchResult.setSpace(doc.getSpace());
            searchResult.setPageName(doc.getDocumentReference().getName());
            searchResult.setVersion(doc.getVersion());
            searchResult.setAuthor(doc.getAuthor());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(doc.getDate());
            searchResult.setModified(calendar);
            if (withPrettyNames.booleanValue()) {
                searchResult.setAuthorName(xwikiApi.getUserName(doc.getAuthor(), false));
            }
            if (StringUtils.isNotEmpty((CharSequence)className) && xwikiContext.getUserReference() != null && (baseObject = (xdocument = xwikiContext.getWiki().getDocument(doc.getDocumentReference(), xwikiContext)).getObject(className)) != null) {
                searchResult.setObject(this.modelFactory.toRestObject(uriInfo.getBaseUri(), doc, baseObject, false, false));
            }
            if (StringUtils.isBlank((CharSequence)language)) {
                pageUri = Utils.createURI(uriInfo.getBaseUri(), PageResource.class, wikiName, Utils.getSpacesURLElements((EntityReference)documentReference.getLastSpaceReference()), documentReference.getName()).toString();
            } else {
                searchResult.setLanguage(language);
                pageUri = Utils.createURI(uriInfo.getBaseUri(), PageTranslationResource.class, wikiName, Utils.getSpacesURLElements((EntityReference)documentReference.getLastSpaceReference()), documentReference.getName(), language).toString();
            }
            Link pageLink = new Link();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            searchResult.getLinks().add(pageLink);
            result.add(searchResult);
        }
        return result;
    }
}

