/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.objects.BaseObject;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.objects.BaseObjectsResource;
import org.xwiki.rest.model.jaxb.Objects;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.objects.ObjectsResourceImpl")
public class ObjectsResourceImpl
extends BaseObjectsResource
implements ObjectsResource {
    @Inject
    private ModelFactory factory;

    public Objects getObjects(String wikiName, String spaceName, String pageName, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            Objects objects = this.objectFactory.createObjects();
            List<BaseObject> objectList = this.getBaseObjects(doc.getDocumentReference());
            RangeIterable<BaseObject> ri = new RangeIterable<BaseObject>(objectList, start, number);
            for (BaseObject object : ri) {
                if (object == null) continue;
                objects.getObjectSummaries().add(DomainObjectFactory.createObjectSummary(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, object, false, Utils.getXWikiApi(this.componentManager), withPrettyNames));
            }
            return objects;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response addObject(String wikiName, String spaceName, String pageName, Boolean minorRevision, org.xwiki.rest.model.jaxb.Object object) throws XWikiRestException {
        if (object.getClassName() == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            List<String> spaces = this.parseSpaceSegments(spaceName);
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaces, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Object xwikiObject = doc.newObject(object.getClassName());
            if (xwikiObject == null) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            this.factory.toObject(xwikiObject, object);
            doc.save("", Boolean.TRUE.equals(minorRevision));
            BaseObject baseObject = this.getBaseObject(doc, object.getClassName(), xwikiObject.getNumber());
            return Response.created((URI)Utils.createURI(this.uriInfo.getBaseUri(), ObjectResource.class, wikiName, spaces, pageName, object.getClassName(), baseObject.getNumber())).entity((java.lang.Object)this.factory.toRestObject(this.uriInfo.getBaseUri(), doc, baseObject, false, false)).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

