/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.objects.BaseObjectsResource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.Properties;
import org.xwiki.rest.resources.objects.ObjectPropertiesResource;
import org.xwiki.rest.resources.objects.ObjectResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.objects.ObjectPropertiesResourceImpl")
public class ObjectPropertiesResourceImpl
extends BaseObjectsResource
implements ObjectPropertiesResource {
    public Properties getObjectProperties(String wikiName, String spaceName, String pageName, String className, Integer objectNumber, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            BaseObject baseObject = this.getBaseObject(doc, className, objectNumber);
            if (baseObject == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            Object object = DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, baseObject, false, Utils.getXWikiApi(this.componentManager), withPrettyNames);
            Properties properties = this.objectFactory.createProperties();
            properties.getProperties().addAll(object.getProperties());
            String objectUri = Utils.createURI(this.uriInfo.getBaseUri(), ObjectResource.class, doc.getWiki(), Utils.getSpacesURLElements((EntityReference)doc.getDocumentReference()), doc.getDocumentReference().getName(), object.getClassName(), object.getNumber()).toString();
            Link objectLink = this.objectFactory.createLink();
            objectLink.setHref(objectUri);
            objectLink.setRel("http://www.xwiki.org/rel/object");
            properties.getLinks().add(objectLink);
            return properties;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

