/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rest.XWikiResource;

public class BaseObjectsResource
extends XWikiResource {
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;

    protected BaseObject getBaseObject(Document doc, String className, int objectNumber) throws XWikiException {
        XWikiContext xWikiContext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument xwikiDocument = xWikiContext.getWiki().getDocument(doc.getDocumentReference(), xWikiContext);
        return xwikiDocument.getObject(className, objectNumber);
    }

    protected List<BaseObject> getBaseObjects(DocumentReference documentReference, String version) throws XWikiException {
        XWikiDocument xwikiDocument = this.documentRevisionProvider.getRevision(documentReference, version);
        return BaseObjectsResource.getBaseObjectList(xwikiDocument);
    }

    protected List<BaseObject> getBaseObjects(DocumentReference documentReference) throws XWikiException {
        XWikiContext xWikiContext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument xwikiDocument = xWikiContext.getWiki().getDocument(documentReference, xWikiContext);
        return BaseObjectsResource.getBaseObjectList(xwikiDocument);
    }

    private static List<BaseObject> getBaseObjectList(XWikiDocument xwikiDocument) {
        return xwikiDocument.getXObjects().values().stream().flatMap(Collection::stream).toList();
    }

    protected List<BaseObject> getBaseObjects(Document doc, String className) throws XWikiException {
        XWikiContext xWikiContext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument xwikiDocument = xWikiContext.getWiki().getDocument(doc.getDocumentReference(), xWikiContext);
        List xwikiObjects = xwikiDocument.getXObjects(xwikiDocument.resolveClassReference(className));
        return xwikiObjects != null ? new ArrayList(xwikiObjects) : Collections.emptyList();
    }
}

