/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.UsersClass;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.QueryBuilder;
import org.xwiki.rest.internal.resources.classes.AbstractUsersAndGroupsClassPropertyValuesProvider;
import org.xwiki.rest.model.jaxb.PropertyValues;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserConfiguration;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.wiki.user.WikiUserManager;

@Component
@Named(value="Users")
@Singleton
public class UsersClassPropertyValuesProvider
extends AbstractUsersAndGroupsClassPropertyValuesProvider<UsersClass> {
    private static final String DEFAULT_ICON_NAME = "user";
    @Inject
    private WikiUserManager wikiUserManager;
    @Inject
    private QueryBuilder<UsersClass> allowedValuesQueryBuilder;
    @Inject
    private UserConfiguration userConfiguration;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;
    @Inject
    private UserPropertiesResolver userPropertiesResolver;

    @Override
    protected Class<UsersClass> getPropertyType() {
        return UsersClass.class;
    }

    @Override
    protected QueryBuilder<UsersClass> getAllowedValuesQueryBuilder() {
        return this.allowedValuesQueryBuilder;
    }

    @Override
    protected PropertyValues getAllowedValues(UsersClass propertyDefinition, int limit, String filter) throws Exception {
        String wikiId = propertyDefinition.getOwnerDocument().getDocumentReference().getWikiReference().getName();
        switch (this.wikiUserManager.getUserScope(wikiId)) {
            case LOCAL_AND_GLOBAL: {
                return this.getLocalAndGlobalAllowedValues(propertyDefinition, limit, filter);
            }
            case GLOBAL_ONLY: {
                return this.getGlobalAllowedValues(propertyDefinition, limit, filter);
            }
        }
        return this.getLocalAllowedValues(propertyDefinition, limit, filter);
    }

    @Override
    protected Map<String, Object> getIcon(DocumentReference userReference) {
        Map<String, Object> icon = new HashMap<String, Object>();
        if (this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)userReference)) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            try {
                XWikiDocument userProfileDocument = xcontext.getWiki().getDocument(userReference, xcontext);
                String avatar = userProfileDocument.getStringValue("avatar");
                XWikiAttachment avatarAttachment = userProfileDocument.getAttachment(avatar);
                if (avatarAttachment != null && avatarAttachment.isImage(xcontext)) {
                    icon.put("url", xcontext.getWiki().getURL((EntityReference)avatarAttachment.getReference(), "download", "width=30&height=30&keepAspectRatio=true", null, xcontext));
                    icon.put("iconSetType", IconType.IMAGE.name());
                }
            }
            catch (XWikiException e) {
                this.logger.warn("Failed to read the avatar of user [{}]. Root cause is [{}]. Using the default avatar instead.", (Object)userReference.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        if (!icon.containsKey("url")) {
            try {
                icon = this.iconManager.getMetaData(DEFAULT_ICON_NAME);
            }
            catch (IconException e) {
                this.logger.warn("Error getting the icon [{}]. Root cause is [{}].", (Object)DEFAULT_ICON_NAME, (Object)ExceptionUtils.getRootCause((Throwable)e));
            }
        }
        return icon;
    }

    @Override
    protected String getLabel(DocumentReference userReference, Object currentLabel) {
        String label;
        String string = label = currentLabel == null ? "" : currentLabel.toString().trim();
        if (label.isEmpty()) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            label = xcontext.getWiki().getPlainUserName(userReference, xcontext);
        }
        return label;
    }

    @Override
    protected String getHint(DocumentReference userReference) {
        String userQualifierProperty = this.userConfiguration.getUserQualifierProperty();
        if (StringUtils.isEmpty((CharSequence)userQualifierProperty)) {
            return super.getHint(userReference);
        }
        return (String)this.getUserProperties(userReference, new Object[0]).getProperty(userQualifierProperty);
    }

    private UserProperties getUserProperties(DocumentReference userReference, Object ... parameters) {
        return this.userPropertiesResolver.resolve(this.userReferenceResolver.resolve((Object)userReference, new Object[0]), parameters);
    }
}

