/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.PageClass;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.QueryBuilder;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rest.internal.resources.classes.AbstractDocumentListClassPropertyValuesProvider;
import org.xwiki.rest.model.jaxb.PropertyValues;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="Page")
@Singleton
public class PageClassPropertyValuesProvider
extends AbstractDocumentListClassPropertyValuesProvider<PageClass> {
    private static final String DEFAULT_ICON_NAME = "page_white";
    @Inject
    private QueryBuilder<PageClass> allowedValuesQueryBuilder;
    @Inject
    private AuthorExecutor authorExecutor;

    @Override
    protected Class<PageClass> getPropertyType() {
        return PageClass.class;
    }

    @Override
    protected PropertyValues getAllowedValues(PageClass pageClass, int limit, String filter) throws Exception {
        return (PropertyValues)this.authorExecutor.call(() -> this.getValues(this.allowedValuesQueryBuilder.build((Object)pageClass), limit, filter, pageClass), pageClass.getOwnerDocument().getAuthorReference(), pageClass.getDocumentReference());
    }

    @Override
    protected Map<String, Object> getIcon(DocumentReference documentReference) {
        HashMap icon;
        try {
            icon = this.iconManager.getMetaData(DEFAULT_ICON_NAME);
        }
        catch (IconException e) {
            this.logger.warn("Error getting the icon [{}]. Root cause is [{}].", (Object)DEFAULT_ICON_NAME, (Object)ExceptionUtils.getRootCause((Throwable)e));
            icon = new HashMap();
        }
        return icon;
    }

    private String getLabel(EntityReference entityReference) {
        String label = null;
        if (this.contextualAuthorizationManager.hasAccess(Right.VIEW, entityReference)) {
            try {
                XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
                XWikiDocument document = xcontext.getWiki().getDocument(entityReference, xcontext).getTranslatedDocument(xcontext);
                label = document.getRenderedTitle(Syntax.PLAIN_1_0, xcontext);
            }
            catch (XWikiException e) {
                this.logger.error("Error while loading the document [{}]. Root cause is [{}]", new Object[]{entityReference, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
        if (label == null) {
            if (entityReference instanceof DocumentReference) {
                DocumentReference documentReference = (DocumentReference)entityReference;
                label = super.getLabel(documentReference, "");
            } else {
                label = entityReference.getName();
            }
        }
        return label;
    }

    @Override
    protected String getLabel(DocumentReference documentReference, Object currentLabel) {
        return this.getLabel((EntityReference)documentReference);
    }

    @Override
    protected String getHint(DocumentReference documentReference) {
        EntityReference parentSpace = documentReference.getParent();
        if ("WebHome".equals(documentReference.getName())) {
            parentSpace = parentSpace.getParent();
        }
        return parentSpace.getReversedReferenceChain().stream().filter(entityReference -> !(entityReference instanceof WikiReference)).map(this::getLabel).collect(Collectors.joining(" / "));
    }
}

