/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.BaseAttachmentsResource;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.attachments.AttachmentsResourceImpl")
public class AttachmentsResourceImpl
extends BaseAttachmentsResource
implements AttachmentsResource {
    private static final String NAME = "name";
    @Inject
    private Container container;

    public Attachments getAttachments(String wiki, String spaces, String page, Integer offset, Integer limit, Boolean withPrettyNames, String name, String author, String fileTypes) throws XWikiRestException {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put(NAME, name);
        filters.put("author", author);
        filters.put("fileTypes", fileTypes);
        return super.getAttachments((EntityReference)new DocumentReference(wiki, this.parseSpaceSegments(spaces), page), filters, offset, this.validateAndGetLimit(limit), withPrettyNames);
    }

    public Response addAttachment(String wikiName, String spaceName, String pageName, Boolean withPrettyNames, Boolean createPage) throws XWikiRestException, AttachmentValidationException {
        ImmutablePair<String, InputStream> file;
        Document doc;
        List<String> spaces;
        try {
            spaces = this.parseSpaceSegments(spaceName);
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaces, pageName, null, null, createPage == false, true);
            doc = documentInfo.getDocument();
            if (!this.authorization.hasAccess(Right.EDIT, (EntityReference)doc.getDocumentReference())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            file = this.getFile();
            if (file.getKey() == null || file.getValue() == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
        try {
            BaseAttachmentsResource.AttachmentInfo attachmentInfo = this.storeAndRetrieveAttachment(doc, (String)file.getKey(), (InputStream)file.getValue(), withPrettyNames);
            if (attachmentInfo.isAlreadyExisting()) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)attachmentInfo.getAttachment()).build();
            }
            return Response.created((URI)Utils.createURI(this.uriInfo.getBaseUri(), AttachmentResource.class, wikiName, spaces, pageName, file.getKey())).entity((Object)attachmentInfo.getAttachment()).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    private ImmutablePair<String, InputStream> getFile() throws IOException, ServletException {
        String originalFileName = null;
        InputStream inputStream = null;
        String overwritingFileName = null;
        HttpServletRequest request = ((ServletRequest)this.container.getRequest()).getHttpServletRequest();
        Collection parts = request.getParts();
        for (Part part : parts) {
            String fileName = part.getSubmittedFileName();
            if (fileName != null) {
                originalFileName = fileName;
                inputStream = part.getInputStream();
                continue;
            }
            if (!"filename".equals(part.getName())) continue;
            overwritingFileName = IOUtils.toString((InputStream)part.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        String attachmentName = overwritingFileName != null ? overwritingFileName : originalFileName;
        return new ImmutablePair(attachmentName, inputStream);
    }
}

