/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.attachment.AttachmentAccessWrapper;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.attachment.validation.AttachmentValidator;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.internal.attachment.XWikiAttachmentAccessWrapper;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReferenceResolver;

public class BaseAttachmentsResource
extends XWikiResource {
    private static final String FILTER_FILE_TYPES = "fileTypes";
    private static final Pattern COMMA = Pattern.compile("\\s*,\\s*");
    private static final String DOT = ".";
    private static final Map<String, String> FILTER_TO_QUERY = new HashMap<String, String>();
    @Inject
    protected ContextualAuthorizationManager authorization;
    @Inject
    private ModelFactory modelFactory;
    @Inject
    @Named(value="hidden/document")
    private QueryFilter hiddenDocumentFilter;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;

    protected Attachments getAttachments(EntityReference scope, Map<String, String> filters, Integer offset, Integer limit, Boolean withPrettyNames) throws XWikiRestException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String database = xcontext.getWikiId();
        Attachments attachments = this.objectFactory.createAttachments();
        try {
            xcontext.setWikiId(scope.extractReference(EntityType.WIKI).getName());
            List queryResults = this.getAttachmentsQuery(scope, filters).setLimit(limit.intValue()).setOffset(offset.intValue()).execute();
            attachments.withAttachments(queryResults.stream().map(this::processAttachmentsQueryResult).filter(this.getFileTypeFilter(filters.getOrDefault(FILTER_FILE_TYPES, ""))).filter(a -> this.authorization.hasAccess(Right.VIEW, (EntityReference)a.getReference())).map(xwikiAttachment -> this.toRestAttachment((XWikiAttachment)xwikiAttachment, withPrettyNames)).toList());
        }
        catch (QueryException e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            xcontext.setWikiId(database);
        }
        return attachments;
    }

    private Query getAttachmentsQuery(EntityReference scope, Map<String, String> filters) throws QueryException {
        StringBuilder statement = new StringBuilder().append("select doc.space, doc.name, doc.version, attachment").append(" from XWikiDocument as doc, XWikiAttachment as attachment");
        HashMap<String, String> exactParams = new HashMap<String, String>();
        HashMap<String, CallSite> prefixParams = new HashMap<String, CallSite>();
        HashMap<String, String> suffixParams = new HashMap<String, String>();
        HashMap<String, String> containsParams = new HashMap<String, String>();
        ArrayList<String> whereClause = new ArrayList<String>();
        whereClause.add("attachment.docId = doc.id");
        if (scope.getType() == EntityType.DOCUMENT) {
            whereClause.add("doc.fullName = :localDocumentReference");
            exactParams.put("localDocumentReference", (String)this.localEntityReferenceSerializer.serialize(scope, new Object[0]));
        } else if (scope.getType() == EntityType.SPACE) {
            whereClause.add("(doc.space = :localSpaceReference or doc.space like :localSpaceReferencePrefix)");
            String localSpaceReference = (String)this.localEntityReferenceSerializer.serialize(scope, new Object[0]);
            exactParams.put("localSpaceReference", localSpaceReference);
            prefixParams.put("localSpaceReferencePrefix", (CallSite)((Object)(localSpaceReference + DOT)));
        }
        this.applyFilters(filters, whereClause, containsParams);
        this.applyFileTypeFilter(filters, whereClause, suffixParams, containsParams);
        statement.append(" where ").append(StringUtils.join(whereClause, (String)" and "));
        Query query = this.queryManager.createQuery(statement.toString(), "hql");
        for (Map.Entry entry : exactParams.entrySet()) {
            query.bindValue((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : prefixParams.entrySet()) {
            query.bindValue((String)entry.getKey()).literal((String)entry.getValue()).anyChars();
        }
        for (Map.Entry entry : suffixParams.entrySet()) {
            query.bindValue((String)entry.getKey()).anyChars().literal((String)entry.getValue());
        }
        for (Map.Entry entry : containsParams.entrySet()) {
            query.bindValue((String)entry.getKey()).anyChars().literal((String)entry.getValue()).anyChars();
        }
        query.addFilter(this.hiddenDocumentFilter);
        return query;
    }

    private void applyFilters(Map<String, String> filters, List<String> constraints, Map<String, String> parameters) {
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            String column = FILTER_TO_QUERY.get(entry.getKey());
            if (StringUtils.isEmpty((CharSequence)entry.getValue()) || column == null) continue;
            constraints.add(String.format("upper(%s) like :%s", column, entry.getKey()));
            parameters.put(entry.getKey(), entry.getValue().toUpperCase());
        }
    }

    private void applyFileTypeFilter(Map<String, String> filters, List<String> constraints, Map<String, String> suffixParams, Map<String, String> containsParams) {
        ArrayList<String> fileTypeConstraints = new ArrayList<String>();
        this.applyMediaTypeFilter(filters, fileTypeConstraints, containsParams);
        this.applyFileNameExtensionFilter(filters, fileTypeConstraints, suffixParams);
        if (!fileTypeConstraints.isEmpty()) {
            constraints.add("(" + StringUtils.join(fileTypeConstraints, (String)" or ") + ")");
        }
    }

    private void applyMediaTypeFilter(Map<String, String> filters, List<String> constraints, Map<String, String> parameters) {
        Set<String> acceptedMediaTypes = this.getAcceptedMediaTypes(filters.getOrDefault(FILTER_FILE_TYPES, ""));
        if (!acceptedMediaTypes.isEmpty()) {
            constraints.add("attachment.mimeType is null");
            constraints.add("attachment.mimeType = ''");
            int index = 0;
            for (String mediaType : acceptedMediaTypes) {
                String parameterName = "mediaType" + index++;
                constraints.add("upper(attachment.mimeType) like :" + parameterName);
                parameters.put(parameterName, mediaType);
            }
        }
    }

    private Set<String> getAcceptedMediaTypes(String fileTypesFilter) {
        return Arrays.asList(COMMA.split(fileTypesFilter)).stream().filter(s -> !s.isEmpty() && !s.startsWith(DOT)).map(String::toUpperCase).collect(Collectors.toSet());
    }

    private void applyFileNameExtensionFilter(Map<String, String> filters, List<String> constraints, Map<String, String> parameters) {
        Set<String> acceptedFileNameExtensions = this.getAcceptedFileNameExtensions(filters.getOrDefault(FILTER_FILE_TYPES, ""));
        if (!acceptedFileNameExtensions.isEmpty()) {
            int index = 0;
            for (String extension : acceptedFileNameExtensions) {
                String parameterName = "extension" + index++;
                constraints.add("upper(attachment.filename) like :" + parameterName);
                parameters.put(parameterName, extension);
            }
        }
    }

    private Set<String> getAcceptedFileNameExtensions(String fileTypesFilter) {
        return Arrays.asList(COMMA.split(fileTypesFilter)).stream().filter(s -> s.startsWith(DOT)).map(String::toUpperCase).collect(Collectors.toSet());
    }

    private XWikiAttachment processAttachmentsQueryResult(Object queryResult) {
        Object[] fields = (Object[])queryResult;
        List<String> pageSpaces = Utils.getSpacesFromSpaceId((String)fields[0]);
        String pageName = (String)fields[1];
        String pageVersion = (String)fields[2];
        XWikiAttachment attachment = (XWikiAttachment)fields[3];
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference documentReference = new DocumentReference(xcontext.getWikiId(), pageSpaces, pageName);
        XWikiDocument document = new XWikiDocument(documentReference);
        document.setVersion(pageVersion);
        attachment.setDoc(document, false);
        return attachment;
    }

    private Predicate<XWikiAttachment> getFileTypeFilter(String acceptedFileTypes) {
        Set<String> acceptedMediaTypes = this.getAcceptedMediaTypes(acceptedFileTypes);
        Set<String> acceptedFileNameExtensions = this.getAcceptedFileNameExtensions(acceptedFileTypes);
        return attachment -> acceptedMediaTypes.isEmpty() || !StringUtils.isEmpty((CharSequence)attachment.getMimeType()) || this.hasAcceptedFileNameExtension((XWikiAttachment)attachment, acceptedFileNameExtensions) || this.hasAcceptedMediaType((XWikiAttachment)attachment, acceptedMediaTypes);
    }

    private boolean hasAcceptedFileNameExtension(XWikiAttachment attachment, Set<String> acceptedFileNameExtensions) {
        String fileName = attachment.getFilename().toUpperCase();
        return acceptedFileNameExtensions.stream().anyMatch(acceptedFileNamedExtension -> fileName.endsWith((String)acceptedFileNamedExtension));
    }

    private boolean hasAcceptedMediaType(XWikiAttachment attachment, Set<String> acceptedMediaTypes) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String detectedMediaType = attachment.getMimeType(xcontext).toUpperCase();
        return acceptedMediaTypes.stream().anyMatch(acceptedMediaType -> detectedMediaType.contains((CharSequence)acceptedMediaType));
    }

    private org.xwiki.rest.model.jaxb.Attachment toRestAttachment(XWikiAttachment xwikiAttachment, Boolean withPrettyNames) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        Attachment apiAttachment = new Attachment(new Document(xwikiAttachment.getDoc(), xcontext), xwikiAttachment, xcontext);
        return this.modelFactory.toRestAttachment(this.uriInfo.getBaseUri(), apiAttachment, withPrettyNames, false);
    }

    protected Attachments getAttachmentsForDocument(Document doc, int start, int number, Boolean withPrettyNames) {
        Attachments attachments = this.objectFactory.createAttachments();
        RangeIterable attachmentsRange = new RangeIterable(doc.getAttachmentList(), start, number);
        for (Attachment xwikiAttachment : attachmentsRange) {
            attachments.getAttachments().add(this.modelFactory.toRestAttachment(this.uriInfo.getBaseUri(), xwikiAttachment, withPrettyNames, false));
        }
        return attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttachmentInfo storeAndRetrieveAttachment(Document document, String attachmentName, InputStream content, Boolean withPrettyNames) throws XWikiException, AttachmentValidationException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument previousDoc = xcontext.getDoc();
        try {
            xcontext.setDoc(document.getDocument());
            boolean alreadyExisting = document.getAttachment(attachmentName) != null;
            XWikiAttachment xwikiAttachment = this.createOrUpdateAttachment(new AttachmentReference(attachmentName, document.getDocumentReference()), content);
            Document updatedDoc = xwikiAttachment.getDoc().newDocument(xcontext);
            org.xwiki.rest.model.jaxb.Attachment attachment = this.modelFactory.toRestAttachment(this.uriInfo.getBaseUri(), new Attachment(updatedDoc, xwikiAttachment, (XWikiContext)this.xcontextProvider.get()), withPrettyNames, false);
            AttachmentInfo attachmentInfo = new AttachmentInfo(attachment, alreadyExisting);
            return attachmentInfo;
        }
        finally {
            xcontext.setDoc(previousDoc);
        }
    }

    protected XWikiAttachment createOrUpdateAttachment(AttachmentReference attachmentReference, InputStream content) throws XWikiException, AttachmentValidationException {
        XWikiAttachment attachment;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        XWikiDocument document = xwiki.getDocument((EntityReference)attachmentReference, xcontext).clone();
        try {
            attachment = document.setAttachment(attachmentReference.getName(), content, xcontext);
        }
        catch (IOException e) {
            throw new XWikiException(3, 3006, String.format("Failed to create or update the attachment [%s].", attachmentReference), (Throwable)e);
        }
        try {
            ((AttachmentValidator)((ComponentManager)this.componentManagerProvider.get()).getInstance(AttachmentValidator.class)).validateAttachment((AttachmentAccessWrapper)new XWikiAttachmentAccessWrapper(attachment, xcontext));
        }
        catch (ComponentLookupException e) {
            throw new XWikiException(String.format("Failed to instantiate a [%s] component.", AttachmentValidator.class.getName()), (Throwable)e);
        }
        if (document.isNew()) {
            document.getAuthors().setCreator(this.documentReferenceUserReferenceResolver.resolve((Object)xcontext.getUserReference(), new Object[0]));
        }
        document.setAuthorReference(xcontext.getUserReference());
        attachment.resetMimeType(xcontext);
        attachment.setCharset(xcontext.getRequest().getCharacterEncoding());
        xwiki.saveDocument(document, xcontext);
        return attachment;
    }

    static {
        FILTER_TO_QUERY.put("space", "doc.space");
        FILTER_TO_QUERY.put("page", "doc.fullName");
        FILTER_TO_QUERY.put("name", "attachment.filename");
        FILTER_TO_QUERY.put("author", "attachment.author");
    }

    protected static class AttachmentInfo {
        protected org.xwiki.rest.model.jaxb.Attachment attachment;
        protected boolean alreadyExisting;

        public AttachmentInfo(org.xwiki.rest.model.jaxb.Attachment attachment, boolean alreadyExisting) {
            this.attachment = attachment;
            this.alreadyExisting = alreadyExisting;
        }

        public org.xwiki.rest.model.jaxb.Attachment getAttachment() {
            return this.attachment;
        }

        public boolean isAlreadyExisting() {
            return this.alreadyExisting;
        }
    }
}

