/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.representations.pages;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.JAXRSUtils;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Page;

@Component
@Named(value="org.xwiki.rest.internal.representations.pages.FormUrlEncodedPageReader")
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Singleton
public class FormUrlEncodedPageReader
implements MessageBodyReader<Page>,
XWikiRestComponent {
    private static final String TITLE_FIELD_NAME = "title";
    private static final String PARENT_FIELD_NAME = "parent";
    private static final String HIDDEN_FIELD_NAME = "hidden";
    private static final String CONTENT_FIELD_NAME = "content";
    @Inject
    private JAXRSUtils jaxrs;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Page.class.isAssignableFrom(type);
    }

    public Page readFrom(Class<Page> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultivaluedMap<String, String> form = this.jaxrs.readForm(mediaType, annotations, entityStream);
        ObjectFactory objectFactory = new ObjectFactory();
        Page page = objectFactory.createPage();
        page.setTitle((String)form.getFirst((Object)TITLE_FIELD_NAME));
        page.setParent((String)form.getFirst((Object)PARENT_FIELD_NAME));
        page.setHidden(Boolean.valueOf((String)form.getFirst((Object)HIDDEN_FIELD_NAME)).booleanValue());
        page.setContent((String)form.getFirst((Object)CONTENT_FIELD_NAME));
        return page;
    }
}

