/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.user.api.XWikiUser;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.http.URIUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.SpaceReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.internal.NoOpQueryFilter;

public class Utils {
    public static String getPageId(String wikiName, List<String> spaceName, String pageName) {
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)com.xpn.xwiki.web.Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING);
        return (String)serializer.serialize((EntityReference)new DocumentReference(wikiName, spaceName, pageName), new Object[0]);
    }

    public static SpaceReference getSpaceReference(List<String> spaces, String wikiName) {
        WikiReference parentReference = new WikiReference(wikiName);
        SpaceReference spaceReference = null;
        for (String space : spaces) {
            spaceReference = new SpaceReference(space, (EntityReference)parentReference);
            parentReference = spaceReference;
        }
        return spaceReference;
    }

    public static String getLocalSpaceId(List<String> spaces) {
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)com.xpn.xwiki.web.Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING, (String)"local");
        return (String)serializer.serialize((EntityReference)Utils.getSpaceReference(spaces, "whatever"), new Object[0]);
    }

    public static String getSpaceId(String wikiName, List<String> spaces) {
        EntityReferenceSerializer defaultEntityReferenceSerializer = (EntityReferenceSerializer)com.xpn.xwiki.web.Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING);
        SpaceReference spaceReference = Utils.getSpaceReference(spaces, wikiName);
        return (String)defaultEntityReferenceSerializer.serialize((EntityReference)spaceReference, new Object[0]);
    }

    public static SpaceReference resolveLocalSpaceId(String spaceId, String wikiName) {
        SpaceReferenceResolver resolver = (SpaceReferenceResolver)com.xpn.xwiki.web.Utils.getComponent((Type)SpaceReferenceResolver.TYPE_STRING);
        return resolver.resolve((Object)spaceId, new Object[]{new WikiReference(wikiName)});
    }

    public static List<String> getSpacesFromSpaceId(String spaceId) {
        return Utils.getSpaces((EntityReference)Utils.resolveLocalSpaceId(spaceId, "whatever"));
    }

    public static List<String> getSpaces(EntityReference entityReference) {
        EntityReference spaceReference = entityReference.extractReference(EntityType.SPACE);
        ArrayList<String> spaces = new ArrayList<String>();
        for (EntityReference ref = spaceReference; ref != null && ref.getType() == EntityType.SPACE; ref = ref.getParent()) {
            spaces.add(ref.getName());
        }
        Collections.reverse(spaces);
        return spaces;
    }

    public static List<String> getSpacesURLElements(EntityReference entityReference) {
        return Utils.getSpacesURLElements(Utils.getSpaces(entityReference));
    }

    public static List<String> getSpacesURLElements(List<String> spaces) {
        ArrayList<String> restSpaces = new ArrayList<String>(spaces.size());
        for (String space : spaces) {
            if (!restSpaces.isEmpty()) {
                restSpaces.add("spaces");
            }
            restSpaces.add(space);
        }
        return restSpaces;
    }

    public static String getPageFullName(String wikiName, List<String> spaces, String pageName) {
        XWikiDocument xwikiDocument = new XWikiDocument(new DocumentReference(wikiName, spaces, pageName));
        Document document = new Document(xwikiDocument, null);
        return document.getFullName();
    }

    public static String getObjectId(String wikiName, List<String> spaces, String pageName, String className, int objectNumber) {
        XWikiDocument xwikiDocument = new XWikiDocument(new DocumentReference(wikiName, spaces, pageName));
        Document document = new Document(xwikiDocument, null);
        return String.format("%s:%s[%d]", document.getPrefixedFullName(), className, objectNumber);
    }

    public static String getPageId(String wikiName, String pageFullName) {
        DocumentReferenceResolver defaultDocumentReferenceResolver = (DocumentReferenceResolver)com.xpn.xwiki.web.Utils.getComponent((Type)DocumentReferenceResolver.TYPE_STRING);
        DocumentReference documentReference = defaultDocumentReferenceResolver.resolve((Object)pageFullName, new Object[]{new WikiReference(wikiName)});
        XWikiDocument xwikiDocument = new XWikiDocument(documentReference);
        Document document = new Document(xwikiDocument, null);
        return document.getPrefixedFullName();
    }

    public static Document getParentDocument(Document doc, XWiki xwikiApi) throws XWikiException {
        if (StringUtils.isEmpty((CharSequence)doc.getParent())) {
            return null;
        }
        Object parentName = doc.getParent();
        if (!((String)parentName).contains(".")) {
            parentName = doc.getSpace() + "." + (String)parentName;
        }
        return xwikiApi.getDocument((String)parentName);
    }

    public static XWikiContext getXWikiContext(ComponentManager componentManager) {
        try {
            Provider xcontextProvider = (Provider)componentManager.getInstance((Type)XWikiContext.TYPE_PROVIDER);
            return (XWikiContext)xcontextProvider.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get XWiki context", e);
        }
    }

    public static com.xpn.xwiki.XWiki getXWiki(ComponentManager componentManager) {
        return Utils.getXWikiContext(componentManager).getWiki();
    }

    public static XWiki getXWikiApi(ComponentManager componentManager) {
        return new XWiki(Utils.getXWiki(componentManager), Utils.getXWikiContext(componentManager));
    }

    public static String getXWikiUser(ComponentManager componentManager) {
        XWikiUser user = Utils.getXWikiContext(componentManager).getXWikiUser();
        if (user == null) {
            return "XWiki.XWikiGuest";
        }
        return user.getFullName();
    }

    public static String getAuthorName(DocumentReference authorReference, ComponentManager componentManager) {
        return Utils.getXWikiContext(componentManager).getWiki().getPlainUserName(authorReference, Utils.getXWikiContext(componentManager));
    }

    public static BaseObject getBaseObject(Document doc, String className, int objectNumber, ComponentManager componentManager) throws XWikiException {
        XWikiDocument xwikiDocument = Utils.getXWiki(componentManager).getDocument(doc.getPrefixedFullName(), Utils.getXWikiContext(componentManager));
        return xwikiDocument.getObject(className, objectNumber);
    }

    public static URI createURI(URI baseURI, Class<?> resourceClass, Object ... pathElements) {
        return Utils.createURI(baseURI, resourceClass, Arrays.asList(pathElements), null);
    }

    public static URI createURI(URI baseURI, Class<?> resourceClass, List<Object> pathElements, Map<String, Object> queryParameters) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)baseURI).path(resourceClass);
        if (queryParameters != null) {
            for (Map.Entry<String, Object> entry : queryParameters.entrySet()) {
                Object value = entry.getValue();
                if (value == null) {
                    uriBuilder.queryParam(entry.getKey(), new Object[0]);
                    continue;
                }
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    uriBuilder.queryParam(entry.getKey(), collection.toArray());
                    continue;
                }
                uriBuilder.queryParam(entry.getKey(), new Object[]{value.toString()});
            }
        }
        List<String> pathVariableNames = null;
        if (!pathElements.isEmpty()) {
            pathVariableNames = Utils.getVariableNamesFromPathTemplate(uriBuilder.toString());
        }
        Object[] encodedPathElements = new String[pathElements.size()];
        for (int i = 0; i < pathElements.size(); ++i) {
            Object pathElement = pathElements.get(i);
            if (pathElement != null) {
                if (i < pathVariableNames.size() && "spaceName".equals(pathVariableNames.get(i))) {
                    if (!(pathElement instanceof List)) {
                        throw new RuntimeException("The 'spaceName' parameter must be a list!");
                    }
                    encodedPathElements[i] = Utils.generateEncodedSpacesURISegment((List)pathElement);
                    continue;
                }
                if (pathElement instanceof List) {
                    List pathElementList = (List)pathElement;
                    encodedPathElements[i] = Utils.generateEncodedListURISegment(pathElementList);
                    continue;
                }
                if (pathElement instanceof EncodedElement) {
                    encodedPathElements[i] = pathElement.toString();
                    continue;
                }
                encodedPathElements[i] = URIUtils.encodePathSegment((String)pathElement.toString());
                continue;
            }
            encodedPathElements[i] = null;
        }
        return uriBuilder.buildFromEncoded(encodedPathElements);
    }

    private static List<String> getVariableNamesFromPathTemplate(String pathTemplate) {
        ArrayList<String> variables = new ArrayList<String>();
        boolean inVariable = false;
        StringBuilder varName = new StringBuilder();
        for (int i = 0; i < pathTemplate.length(); ++i) {
            char c = pathTemplate.charAt(i);
            if (inVariable) {
                if (c == '}') {
                    variables.add(varName.toString());
                    varName.delete(0, varName.length());
                    inVariable = false;
                    continue;
                }
                varName.append(c);
                continue;
            }
            if (c != '{') continue;
            inVariable = true;
        }
        return variables;
    }

    private static String generateEncodedListURISegment(List<Object> listSegment) {
        StringBuilder jobIdSegment = new StringBuilder();
        for (Object idElement : listSegment) {
            if (jobIdSegment.length() > 0) {
                jobIdSegment.append('/');
            }
            jobIdSegment.append(URIUtils.encodePathSegment((String)idElement.toString()));
        }
        return jobIdSegment.toString();
    }

    private static String generateEncodedSpacesURISegment(List<Object> spaces) {
        StringBuilder spaceSegment = new StringBuilder();
        for (Object space : spaces) {
            if (spaceSegment.length() > 0) {
                spaceSegment.append("/spaces/");
            }
            spaceSegment.append(URIUtils.encodePathSegment((String)space.toString()));
        }
        return spaceSegment.toString();
    }

    public static QueryFilter getHiddenQueryFilter(ComponentManager componentManager) {
        QueryFilter filter;
        try {
            filter = (QueryFilter)componentManager.getInstance(QueryFilter.class, "hidden");
        }
        catch (ComponentLookupException e) {
            filter = new NoOpQueryFilter();
        }
        return filter;
    }

    public class EncodedElement {
        private String encodedElement;

        public EncodedElement(String encodedElement) {
            this.encodedElement = encodedElement;
        }

        public String toString() {
            return this.encodedElement;
        }
    }
}

