/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Class;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.Property;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.objects.BaseObject;
import java.net.URI;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.model.jaxb.JobLog;
import org.xwiki.rest.model.jaxb.JobProgress;
import org.xwiki.rest.model.jaxb.JobStatus;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.ObjectSummary;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Translations;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Xwiki;
import org.xwiki.rest.resources.ClientResource;
import org.xwiki.rest.resources.SyntaxesResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationVersionResource;
import org.xwiki.rest.resources.pages.PageVersionResource;
import org.xwiki.rest.resources.wikis.WikisResource;

public class DomainObjectFactory {
    public static ModelFactory getModelFactory() {
        return (ModelFactory)com.xpn.xwiki.web.Utils.getComponent(ModelFactory.class);
    }

    public static Xwiki createXWikiRoot(ObjectFactory objectFactory, URI baseUri, String version) {
        Xwiki xwiki = objectFactory.createXwiki().withVersion(version);
        String wikisUri = DomainObjectFactory.uri(baseUri, WikisResource.class, new java.lang.Object[0]);
        Link wikisLink = objectFactory.createLink();
        wikisLink.setHref(wikisUri);
        wikisLink.setRel("http://www.xwiki.org/rel/wikis");
        xwiki.getLinks().add(wikisLink);
        String syntaxesUri = DomainObjectFactory.uri(baseUri, SyntaxesResource.class, new java.lang.Object[0]);
        Link syntaxesLink = objectFactory.createLink();
        syntaxesLink.setHref(syntaxesUri);
        syntaxesLink.setRel("http://www.xwiki.org/rel/syntaxes");
        xwiki.getLinks().add(syntaxesLink);
        String clientUri = DomainObjectFactory.uri(baseUri, ClientResource.class, new java.lang.Object[0]);
        Link clientLink = objectFactory.createLink();
        clientLink.setHref(clientUri);
        clientLink.setRel("http://www.xwiki.org/rel/client");
        xwiki.getLinks().add(clientLink);
        return xwiki;
    }

    @Deprecated
    public static Wiki createWiki(ObjectFactory objectFactory, URI baseUri, String wikiName) {
        return DomainObjectFactory.getModelFactory().toRestWiki(baseUri, wikiName);
    }

    @Deprecated
    public static Space createSpace(ObjectFactory objectFactory, URI baseUri, String wikiName, List<String> spaces, Document home) {
        return DomainObjectFactory.getModelFactory().toRestSpace(baseUri, wikiName, spaces, home);
    }

    @Deprecated
    public static Translations createTranslations(ObjectFactory objectFactory, URI baseUri, Document doc) throws XWikiException {
        return DomainObjectFactory.getModelFactory().toRestTranslations(baseUri, doc);
    }

    @Deprecated
    public static PageSummary createPageSummary(ObjectFactory objectFactory, URI baseUri, Document doc, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        return DomainObjectFactory.getModelFactory().toRestPageSummary(baseUri, doc, withPrettyNames);
    }

    @Deprecated
    public static Page createPage(ObjectFactory objectFactory, URI baseUri, URI self, Document doc, boolean useVersion, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        return DomainObjectFactory.getModelFactory().toRestPage(baseUri, self, doc, useVersion, withPrettyNames, false, false, false);
    }

    public static HistorySummary createHistorySummary(ObjectFactory objectFactory, URI baseUri, String wikiName, List<String> spaces, String pageName, String language, Version version, String modifier, Date modified, String comment, XWiki xwikiApi, Boolean withPrettyNames) {
        HistorySummary historySummary = objectFactory.createHistorySummary();
        String pageId = Utils.getPageId(wikiName, spaces, pageName);
        historySummary.setPageId(pageId);
        historySummary.setWiki(wikiName);
        historySummary.setSpace(Utils.getLocalSpaceId(spaces));
        historySummary.setName(pageName);
        historySummary.setVersion(version.toString());
        historySummary.setMajorVersion(version.at(0));
        historySummary.setMinorVersion(version.at(1));
        historySummary.setComment(comment);
        historySummary.setModifier(modifier);
        if (withPrettyNames.booleanValue()) {
            historySummary.setModifierName(xwikiApi.getUserName(modifier, false));
        }
        historySummary.setLanguage(language);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(modified);
        historySummary.setModified(calendar);
        if (language == null) {
            String pageUri = DomainObjectFactory.uri(baseUri, PageVersionResource.class, wikiName, spaces, pageName, version);
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            historySummary.getLinks().add(pageLink);
        } else {
            String pageUri = DomainObjectFactory.uri(baseUri, PageTranslationVersionResource.class, wikiName, spaces, pageName, language, version);
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            historySummary.getLinks().add(pageLink);
        }
        return historySummary;
    }

    @Deprecated
    public static org.xwiki.rest.model.jaxb.Attachment createAttachment(ObjectFactory objectFactory, URI baseUri, Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl, XWiki xwikiApi, Boolean withPrettyNames) {
        return DomainObjectFactory.getModelFactory().toRestAttachment(baseUri, xwikiAttachment, xwikiRelativeUrl, xwikiAbsoluteUrl, withPrettyNames, false);
    }

    @Deprecated
    public static org.xwiki.rest.model.jaxb.Attachment createAttachmentAtVersion(ObjectFactory objectFactory, URI baseUri, Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl, XWiki xwikiApi, Boolean withPrettyNames) {
        return DomainObjectFactory.getModelFactory().toRestAttachment(baseUri, xwikiAttachment, xwikiRelativeUrl, xwikiAbsoluteUrl, withPrettyNames, true);
    }

    public static Comment createComment(ObjectFactory objectFactory, URI baseUri, Document doc, Object xwikiComment, XWiki xwikiApi, Boolean withPrettyNames) {
        Comment comment = objectFactory.createComment();
        comment.setId(xwikiComment.getNumber());
        Property property = xwikiComment.getProperty("author");
        if (property != null) {
            comment.setAuthor((String)property.getValue());
            if (withPrettyNames.booleanValue()) {
                comment.setAuthorName(xwikiApi.getUserName((String)property.getValue(), false));
            }
        }
        if ((property = xwikiComment.getProperty("date")) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)property.getValue());
            comment.setDate(calendar);
        }
        if ((property = xwikiComment.getProperty("highlight")) != null) {
            comment.setHighlight((String)property.getValue());
        }
        if ((property = xwikiComment.getProperty("comment")) != null) {
            comment.setText((String)property.getValue());
        }
        if ((property = xwikiComment.getProperty("replyto")) != null) {
            comment.setReplyTo((Integer)property.getValue());
        }
        String pageUri = DomainObjectFactory.uri(baseUri, PageResource.class, doc.getWiki(), Utils.getSpacesURLElements((EntityReference)doc.getDocumentReference()), doc.getDocumentReference().getName());
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        comment.getLinks().add(pageLink);
        return comment;
    }

    @Deprecated
    public static ObjectSummary createObjectSummary(ObjectFactory objectFactory, URI baseUri, XWikiContext xwikiContext, Document doc, BaseObject xwikiObject, boolean useVersion, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        return DomainObjectFactory.getModelFactory().toRestObjectSummary(baseUri, doc, xwikiObject, useVersion, withPrettyNames);
    }

    @Deprecated
    public static org.xwiki.rest.model.jaxb.Object createObject(ObjectFactory objectFactory, URI baseUri, XWikiContext xwikiContext, Document doc, BaseObject xwikiObject, boolean useVersion, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        return DomainObjectFactory.getModelFactory().toRestObject(baseUri, doc, xwikiObject, useVersion, withPrettyNames);
    }

    @Deprecated
    public static JobStatus createJobStatus(ObjectFactory objectFactory, URI self, org.xwiki.job.event.status.JobStatus jobStatus) throws XWikiRestException {
        return DomainObjectFactory.getModelFactory().toRestJobStatus(jobStatus, self, false, true, false, null);
    }

    @Deprecated
    public static JobProgress createJobProgress(ObjectFactory objectFactory, org.xwiki.job.event.status.JobProgress jobProgress) {
        return DomainObjectFactory.getModelFactory().toRestJobProgress(jobProgress);
    }

    @Deprecated
    public static JobLog createLog(ObjectFactory objectFactory, URI self, Collection<LogEvent> logs) {
        return DomainObjectFactory.getModelFactory().toRestJobLog(logs, self);
    }

    public static org.xwiki.rest.model.jaxb.Class createClass(ObjectFactory objectFactory, URI baseUri, String wikiName, Class xwikiClass) {
        return DomainObjectFactory.getModelFactory().toRestClass(baseUri, xwikiClass);
    }

    private static String uri(URI baseURI, java.lang.Class<?> resourceClass, java.lang.Object ... pathElements) {
        return Utils.createURI(baseURI, resourceClass, pathElements).toString();
    }
}

