/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.jersey.internal;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rest.jersey.internal.JerseyServletContainer;

public class XWikiRESTServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private volatile JerseyServletContainer container;

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (this.container == null) {
            this.initializeCountainer(req.getServletContext());
        }
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("non-HTTP request or response");
        }
        Object httpRequest = (HttpServletRequest)req;
        String requestURI = httpRequest.getRequestURI();
        if (StringUtils.contains((CharSequence)requestURI, (int)43)) {
            final String encodedRequestURI = this.encodePlus(requestURI);
            final StringBuffer encodedRequestUrl = new StringBuffer(this.encodePlus(httpRequest.getRequestURL().toString()));
            httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                public String getRequestURI() {
                    return encodedRequestURI;
                }

                public StringBuffer getRequestURL() {
                    return encodedRequestUrl;
                }
            };
        }
        this.container.service((ServletRequest)httpRequest, res);
    }

    private String encodePlus(String path) {
        return path.replace("+", "%20");
    }

    private synchronized void initializeCountainer(ServletContext servletContext) throws ServletException {
        if (this.container != null) {
            return;
        }
        ComponentManager rootComponentManager = (ComponentManager)servletContext.getAttribute(ComponentManager.class.getName());
        servletContext.setAttribute("jersey.config.servlet.context.serviceLocator", (Object)rootComponentManager);
        try {
            JerseyServletContainer newContainer = (JerseyServletContainer)((Object)rootComponentManager.getInstance(JerseyServletContainer.class));
            newContainer.init(this.getServletConfig());
            this.container = newContainer;
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to lookup the Jersey container", (Throwable)e);
        }
    }

    public void destroy() {
        this.container.destroy();
    }

    public ServletContext getServletContext() {
        return this.container.getServletContext();
    }
}

