/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.temporary.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.resource.temporary.TemporaryResourceStore;
import org.xwiki.script.service.ScriptService;
import org.xwiki.url.ExtendedURL;

@Component
@Named(value="resource.temporary")
@Singleton
public class TemporaryResourceScriptService
implements ScriptService {
    public static final String ROLE_HINT = "resource.temporary";
    private static final String TEMP_RESOURCE_ERROR_KEY = String.format("scriptservice.%s.error", "resource.temporary");
    @Inject
    private ResourceReferenceSerializer<ResourceReference, ExtendedURL> resourceReferenceSerializer;
    @Inject
    private TemporaryResourceStore temporaryResourceStore;
    @Inject
    private Execution execution;

    public String getURL(TemporaryResourceReference tempResourceReference) {
        this.setError(null);
        try {
            return ((ExtendedURL)this.resourceReferenceSerializer.serialize((ResourceReference)tempResourceReference)).serialize();
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public boolean exists(TemporaryResourceReference tempResourceReference) {
        try {
            return this.temporaryResourceStore.getTemporaryFile(tempResourceReference).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(TEMP_RESOURCE_ERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(TEMP_RESOURCE_ERROR_KEY, (Object)e);
    }
}

