/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.temporary.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.annotations.Authenticate;
import org.xwiki.resource.servlet.AbstractServletResourceReferenceHandler;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.resource.temporary.TemporaryResourceStore;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="tmp")
@Singleton
@Authenticate
public class TemporaryResourceReferenceHandler
extends AbstractServletResourceReferenceHandler<TemporaryResourceReference> {
    @Inject
    private TemporaryResourceStore store;
    @Inject
    private ContextualAuthorizationManager authorization;

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(TemporaryResourceReference.TYPE);
    }

    protected boolean isResourceAccessible(TemporaryResourceReference resourceReference) {
        return this.authorization.hasAccess(Right.VIEW, resourceReference.getOwningEntityReference());
    }

    protected InputStream getResourceStream(TemporaryResourceReference resourceReference) {
        try {
            return new FileInputStream(this.store.getTemporaryFile(resourceReference));
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String getResourceName(TemporaryResourceReference resourceReference) {
        return resourceReference.getResourceName();
    }
}

