/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.temporary.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceLoader;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.resource.temporary.TemporaryResourceStore;

@Component
@Singleton
public class TemporaryResourceLoader
implements ResourceLoader<TemporaryResourceReference> {
    @Inject
    private Logger logger;
    @Inject
    private TemporaryResourceStore temporaryResourceStore;

    public InputStream load(TemporaryResourceReference reference) {
        FileInputStream result = null;
        try {
            File file = this.temporaryResourceStore.getTemporaryFile(reference);
            result = new FileInputStream(file);
        }
        catch (Exception e) {
            this.logger.debug("Failed to get the temporary resource's content for [{}]", (Object)reference, (Object)e);
        }
        return result;
    }
}

