/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.temporary.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;

@Component
@Named(value="standard/tmp")
@Singleton
public class ExtendedURLTemporaryResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    @Inject
    @Named(value="url")
    private EntityReferenceResolver<String> urlEntityReferenceResolver;

    public TemporaryResourceReference resolve(ExtendedURL extendedURL, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException {
        List segments = extendedURL.getSegments();
        if (segments.size() < 3) {
            throw new CreateResourceReferenceException(String.format("Invalid temporary resource URL format [%s].", extendedURL));
        }
        String moduleId = (String)segments.get(0);
        EntityReference owningEntityReference = this.resolveEntityReference((String)segments.get(1));
        List<String> resourcePath = segments.subList(2, segments.size());
        TemporaryResourceReference reference = new TemporaryResourceReference(moduleId, resourcePath, owningEntityReference);
        this.copyParameters(extendedURL, (ResourceReference)reference);
        return reference;
    }

    private EntityReference resolveEntityReference(String representation) throws CreateResourceReferenceException {
        int index = representation.indexOf(58);
        if (index > 0) {
            String entityTypeString = representation.substring(0, index);
            try {
                EntityType entityType = EntityType.valueOf((String)entityTypeString.toUpperCase());
                return this.urlEntityReferenceResolver.resolve((Object)representation.substring(index + 1), entityType, new Object[0]);
            }
            catch (Exception e) {
                throw new CreateResourceReferenceException(String.format("Unknown entity type [%s].", entityTypeString));
            }
        }
        throw new CreateResourceReferenceException(String.format("Entity type is missing from [%s].", representation));
    }
}

