/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReferenceHandlerManager;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.ResourceTypeResolver;
import org.xwiki.url.ExtendedURL;

public class RoutingFilter
implements Filter {
    static final String RESOURCE_TYPE_NAME = "resourceType";
    static final String RESOURCE_EXTENDEDURL = "resourceURL";
    private ComponentManager rootComponentManager;
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.rootComponentManager = (ComponentManager)filterConfig.getServletContext().getAttribute(ComponentManager.class.getName());
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ResourceType resourceType;
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExtendedURL extendedURL = this.constructExtendedURL(httpRequest);
        ResourceTypeResolver<ExtendedURL> urlResourceTypeResolver = this.getResourceTypeResolver();
        try {
            resourceType = urlResourceTypeResolver.resolve((Object)extendedURL, Collections.emptyMap());
        }
        catch (Exception e) {
            chain.doFilter(request, response);
            return;
        }
        if (resourceType.isStatic()) {
            chain.doFilter(request, response);
            return;
        }
        ResourceReferenceHandlerManager<ResourceType> resourceReferenceHandlerManager = this.getResourceReferenceHandlerManager();
        if (!resourceReferenceHandlerManager.canHandle((Object)resourceType)) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(RESOURCE_TYPE_NAME, (Object)resourceType);
        request.setAttribute(RESOURCE_EXTENDEDURL, (Object)extendedURL);
        this.servletContext.getNamedDispatcher("resourceReferenceHandler").forward(request, response);
    }

    public void destroy() {
        this.rootComponentManager = null;
        this.servletContext = null;
    }

    private ResourceReferenceHandlerManager<ResourceType> getResourceReferenceHandlerManager() throws ServletException {
        ResourceReferenceHandlerManager resourceReferenceHandlerManager;
        try {
            resourceReferenceHandlerManager = (ResourceReferenceHandlerManager)this.rootComponentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceHandlerManager.class, new Type[]{ResourceType.class}));
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to locate a Resource Reference Handler Manager component", (Throwable)e);
        }
        return resourceReferenceHandlerManager;
    }

    private ResourceTypeResolver<ExtendedURL> getResourceTypeResolver() throws ServletException {
        ResourceTypeResolver urlResourceTypeResolver;
        try {
            urlResourceTypeResolver = (ResourceTypeResolver)this.rootComponentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceTypeResolver.class, new Type[]{ExtendedURL.class}));
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to locate an ExtendedURL Resource Type Resolver component", (Throwable)e);
        }
        return urlResourceTypeResolver;
    }

    private ExtendedURL constructExtendedURL(HttpServletRequest httpRequest) throws ServletException {
        ExtendedURL extendedURL;
        URL url = this.getRequestURL(httpRequest);
        try {
            extendedURL = new ExtendedURL(url, httpRequest.getContextPath());
        }
        catch (CreateResourceReferenceException e) {
            throw new ServletException(String.format("Invalid URL [%s]", url), (Throwable)e);
        }
        return extendedURL;
    }

    private URL getRequestURL(HttpServletRequest request) throws ServletException {
        URL url;
        try {
            StringBuffer requestURL = request.getRequestURL();
            String qs = request.getQueryString();
            url = !StringUtils.isEmpty((CharSequence)qs) ? new URL(requestURL.toString() + "?" + qs) : new URL(requestURL.toString());
        }
        catch (MalformedURLException e) {
            throw new ServletException(String.format("Failed to reconstruct URL from HTTP Servlet Request (URL [%s], Query String [%s])", request.getRequestURL(), request.getQueryString()), (Throwable)e);
        }
        return url;
    }
}

