/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.servlet;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.tika.internal.TikaUtils;

public abstract class AbstractServletResourceReferenceHandler<R extends ResourceReference>
extends AbstractResourceReferenceHandler<ResourceType> {
    private static final long CACHE_DURATION = 31536000000L;
    @Inject
    private Logger logger;
    @Inject
    private Container container;

    public void handle(ResourceReference resourceReference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        block18: {
            ResourceReference typedResourceReference = resourceReference;
            if (!this.isResourceAccessible(typedResourceReference)) {
                this.sendError(403, "You are not allowed to view [%s].", this.getResourceName(typedResourceReference));
            } else if (!this.shouldBrowserUseCachedContent(typedResourceReference)) {
                try (InputStream resourceStream = this.getResourceStream(typedResourceReference);){
                    if (resourceStream != null) {
                        try (InputStream filteredSteam = this.filterResource(typedResourceReference, resourceStream);){
                            this.serveResource(typedResourceReference, filteredSteam);
                            break block18;
                        }
                    }
                    this.sendError(404, "Resource not found [%s].", this.getResourceName(typedResourceReference));
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    this.sendError(500, e.getMessage(), new Object[0]);
                }
            }
        }
        chain.handleNext(resourceReference);
    }

    protected boolean isResourceAccessible(R resourceReference) {
        return true;
    }

    private boolean shouldBrowserUseCachedContent(R resourceReference) {
        Response response;
        ServletRequest servletRequest;
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest && (servletRequest = (ServletRequest)request).getRequest().getHeader("If-Modified-Since") != null && this.isResourceCacheable(resourceReference) && (response = this.container.getResponse()) instanceof ServletResponse) {
            ServletResponse servletResponse = (ServletResponse)response;
            servletResponse.getResponse().setStatus(304);
            return true;
        }
        return false;
    }

    protected boolean isResourceCacheable(R resourceReference) {
        return true;
    }

    protected abstract InputStream getResourceStream(R var1);

    protected abstract String getResourceName(R var1);

    private void serveResource(R resourceReference, InputStream rawResourceStream) throws ResourceReferenceHandlerException {
        InputStream resourceStream = rawResourceStream;
        if (!resourceStream.markSupported()) {
            resourceStream = new BufferedInputStream(resourceStream);
        }
        try {
            Response response = this.container.getResponse();
            this.setResponseHeaders(response, resourceReference);
            response.setContentType(this.getContentType(resourceStream, resourceReference));
            IOUtils.copy((InputStream)resourceStream, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            String resourceName = this.getResourceName(resourceReference);
            throw new ResourceReferenceHandlerException(String.format("Failed to read resource [%s]", resourceName), (Throwable)e);
        }
    }

    protected String getContentType(InputStream resourceStream, R resourceReference) throws IOException {
        return TikaUtils.detect((InputStream)resourceStream, (String)this.getResourceName(resourceReference));
    }

    protected InputStream filterResource(R resourceReference, InputStream resourceStream) throws ResourceReferenceHandlerException {
        return resourceStream;
    }

    private void setResponseHeaders(Response response, R resourceReference) {
        String fileName;
        if (!(response instanceof ServletResponse)) {
            return;
        }
        HttpServletResponse httpResponse = ((ServletResponse)response).getResponse();
        if (this.isResourceCacheable(resourceReference)) {
            httpResponse.setHeader("Cache-Control", "public");
            httpResponse.setDateHeader("Expires", new Date().getTime() + 31536000000L);
            httpResponse.setDateHeader("Last-Modified", new Date().getTime());
        }
        if (!StringUtils.isEmpty((CharSequence)(fileName = this.getFileName(resourceReference)))) {
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            httpResponse.setHeader("Content-Disposition", ";filename*=utf-8''" + fileName);
        }
    }

    private String getFileName(R resourceReference) {
        String fileName = resourceReference.getParameterValue("fileName");
        if (fileName != null) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            if (!Objects.equals(StringUtils.substringAfterLast((String)(fileName = fileName.substring(fileName.lastIndexOf(92) + 1)), (int)46), StringUtils.substringAfterLast((String)this.getResourceName(resourceReference), (int)46))) {
                fileName = null;
            }
        }
        return fileName;
    }

    private void sendError(int statusCode, String message, Object ... parameters) throws ResourceReferenceHandlerException {
        Response response = this.container.getResponse();
        if (response instanceof ServletResponse) {
            ServletResponse servletResponse = (ServletResponse)response;
            HttpServletResponse httpResponse = servletResponse.getResponse();
            try {
                httpResponse.sendError(statusCode, String.format(message, parameters));
            }
            catch (IOException e) {
                throw new ResourceReferenceHandlerException(String.format("Failed to return status code [%s].", statusCode), (Throwable)e);
            }
        }
    }
}

