/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.internal.entity;

import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.resource.ResourceLoader;
import org.xwiki.resource.entity.EntityResourceReference;

@Component
@Singleton
public class EntityResourceLoader
implements ResourceLoader<EntityResourceReference> {
    @Inject
    private Logger logger;
    @Inject
    private DocumentAccessBridge dab;

    public InputStream load(EntityResourceReference reference) {
        InputStream result = null;
        EntityReference entityReference = reference.getEntityReference();
        if (EntityType.ATTACHMENT.equals((Object)entityReference.getType()) || EntityType.PAGE_ATTACHMENT.equals((Object)entityReference.getType())) {
            try {
                result = this.dab.getAttachmentContent(entityReference);
            }
            catch (Exception e) {
                this.logger.debug("Failed to get attachment's content for [{}]", (Object)entityReference, (Object)e);
            }
        }
        return result;
    }
}

