/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.util;

import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={XWikiSyntaxEscaper.class})
@Singleton
public class XWikiSyntaxEscaper {
    public String escape(String content, Syntax syntax) {
        char escapeChar;
        if (content == null || syntax == null) {
            return null;
        }
        try {
            escapeChar = this.getEscapeCharacter(syntax);
        }
        catch (Exception e) {
            return null;
        }
        char[] result = new char[content.length() * 2];
        for (int i = 0; i < content.length(); ++i) {
            result[2 * i] = escapeChar;
            result[2 * i + 1] = content.charAt(i);
        }
        return String.valueOf(result);
    }

    private char getEscapeCharacter(Syntax syntax) throws IllegalArgumentException {
        if (Syntax.XWIKI_1_0.equals((Object)syntax)) {
            return '\\';
        }
        if (Syntax.XWIKI_2_0.equals((Object)syntax) || Syntax.XWIKI_2_1.equals((Object)syntax)) {
            return '~';
        }
        throw new IllegalArgumentException(String.format("Escaping is not supported for Syntax [%s]", syntax));
    }
}

