/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.logging.Message;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.internal.util.DefaultErrorBlockGenerator;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
public class XWikiErrorBlockGenerator
extends DefaultErrorBlockGenerator {
    private static final String CONTEXT_ATTRIBUTE = "renderingerror";
    private static final String ECONTEXT_MARKER = "rendering.error.xwiki.template";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private Provider<ScriptContextManager> scriptContextManagerProvider;
    @Inject
    private Execution execution;

    private List<Block> executeTemplate(String messageId, Message message, Message description, boolean inline) {
        Template template;
        TemplateManager templateManager;
        ExecutionContext econtext = this.execution.getContext();
        if (econtext.hasProperty(ECONTEXT_MARKER) || !this.componentManager.hasComponent(TemplateManager.class)) {
            return null;
        }
        try {
            templateManager = (TemplateManager)this.componentManager.getInstance(TemplateManager.class);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup TemplateManger component", (Throwable)e);
            return null;
        }
        Template template2 = template = messageId != null ? templateManager.getTemplate("xwikirenderingerror/" + messageId + ".vm") : null;
        if (template == null) {
            template = templateManager.getTemplate("xwikirenderingerror/default.vm");
        }
        if (template != null) {
            return this.executeTemplate(template, templateManager, messageId, message, description, inline, econtext);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Block> executeTemplate(Template template, TemplateManager templateManager, String messageId, Message message, Message description, boolean inline, ExecutionContext econtext) {
        ScriptContext scriptContext = ((ScriptContextManager)this.scriptContextManagerProvider.get()).getCurrentScriptContext();
        Object currentRenderingerror = scriptContext.getAttribute(CONTEXT_ATTRIBUTE, 200);
        boolean renderingContextPushed = false;
        try {
            Block block;
            econtext.newProperty(ECONTEXT_MARKER).initial((Object)true).declare();
            HashMap<String, Object> renderingerror = new HashMap<String, Object>();
            renderingerror.put("messageId", messageId);
            renderingerror.put("message", message);
            renderingerror.put("description", description);
            renderingerror.put("inline", inline);
            if (message.getThrowable() != null) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)message.getThrowable());
                renderingerror.put("rootCause", rootCause != null ? rootCause : message.getThrowable());
                renderingerror.put("stackTrace", ExceptionUtils.getStackTrace((Throwable)message.getThrowable()));
            }
            scriptContext.setAttribute(CONTEXT_ATTRIBUTE, renderingerror, 200);
            if (this.renderingContext.isRestricted() && this.renderingContext instanceof MutableRenderingContext) {
                ((MutableRenderingContext)this.renderingContext).push(this.renderingContext.getTransformation(), this.renderingContext.getXDOM(), this.renderingContext.getDefaultSyntax(), this.renderingContext.getTransformationId(), false, this.renderingContext.getTargetSyntax());
                renderingContextPushed = true;
            }
            List<Block> list = (block = templateManager.execute(template, inline)) instanceof XDOM || block instanceof CompositeBlock ? block.getChildren() : Collections.singletonList(block);
            return list;
        }
        catch (Exception e) {
            this.logger.error("Failed to generate error rendering message", (Throwable)e);
        }
        finally {
            if (renderingContextPushed) {
                ((MutableRenderingContext)this.renderingContext).pop();
            }
            scriptContext.setAttribute(CONTEXT_ATTRIBUTE, currentRenderingerror, 200);
            econtext.removeProperty(ECONTEXT_MARKER);
        }
        return null;
    }

    protected List<Block> generateErrorBlocks(boolean inline, Message message, Message description) {
        String messageId = message.getMarker() instanceof TranslationMarker ? ((TranslationMarker)message.getMarker()).getTranslationKey() : null;
        List<Block> blocks = this.executeTemplate(messageId, message, description, inline);
        if (blocks != null) {
            return blocks;
        }
        return super.generateErrorBlocks(inline, message, description);
    }
}

