/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.resolver;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.internal.resolver.AbstractRelativeResourceReferenceEntityReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@Named(value="relative/doc")
@Singleton
public class RelativeDocumentResourceReferenceEntityReferenceResolver
extends AbstractRelativeResourceReferenceEntityReferenceResolver {
    @Inject
    private DocumentReferenceResolver<String> defaultStringDocumentReferenceResolver;
    @Inject
    private DocumentReferenceResolver<EntityReference> documentReferenceResolver;

    public RelativeDocumentResourceReferenceEntityReferenceResolver() {
        super(ResourceType.DOCUMENT);
    }

    @Override
    protected EntityType getEntityType() {
        return EntityType.DOCUMENT;
    }

    @Override
    protected EntityReference resolveUntyped(ResourceReference resourceReference, EntityReference baseReference) {
        if (StringUtils.isEmpty((CharSequence)resourceReference.getReference())) {
            return this.resolveTyped(resourceReference, baseReference);
        }
        EntityReference relativeReference = this.relativeReferenceResolver.resolve((Object)resourceReference.getReference(), EntityType.DOCUMENT, new Object[]{baseReference});
        if (relativeReference != null && (relativeReference.extractReference(EntityType.SPACE) == null || relativeReference.extractReference(EntityType.WIKI) == null)) {
            return this.setDefaultDocument(relativeReference);
        }
        DocumentReference reference = this.defaultStringDocumentReferenceResolver.resolve((Object)resourceReference.getReference(), new Object[]{baseReference});
        return this.resolveDocumentReference(relativeReference, reference, baseReference);
    }

    private EntityReference setDefaultDocument(EntityReference relativeReference) {
        EntityReference result;
        String defaultDocumentName = this.defaultReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        if (!defaultDocumentName.equals(relativeReference.getName())) {
            EntityReference parentSpace = new EntityReference(relativeReference.getName(), EntityType.SPACE, relativeReference.getParent());
            result = new EntityReference(defaultDocumentName, EntityType.DOCUMENT, parentSpace);
        } else {
            result = relativeReference;
        }
        EntityReference oldSpaceReference = result.extractFirstReference(EntityType.SPACE);
        if (oldSpaceReference != null) {
            EntityReference newSpaceReference = new EntityReference(oldSpaceReference, Map.of("parentType", EntityType.SPACE));
            result = result.replaceParent(oldSpaceReference, newSpaceReference);
        }
        return result;
    }
}

