/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.resolver;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.internal.resolver.AbstractRelativeResourceReferenceEntityReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@Named(value="relative/attach")
@Singleton
public class RelativeAttachmentResourceReferenceEntityReferenceResolver
extends AbstractRelativeResourceReferenceEntityReferenceResolver {
    @Inject
    private AttachmentReferenceResolver<EntityReference> defaultReferenceAttachmentReferenceResolver;

    public RelativeAttachmentResourceReferenceEntityReferenceResolver() {
        super(ResourceType.ATTACHMENT);
    }

    @Override
    protected EntityType getEntityType() {
        return EntityType.ATTACHMENT;
    }

    @Override
    protected EntityReference resolveTyped(ResourceReference resourceReference, EntityReference baseReference) {
        EntityReference relativeReference;
        if (StringUtils.isEmpty((CharSequence)resourceReference.getReference())) {
            return null;
        }
        EntityReference result = relativeReference = this.relativeReferenceResolver.resolve((Object)resourceReference.getReference(), EntityType.ATTACHMENT, new Object[]{baseReference});
        if (relativeReference.extractReference(EntityType.WIKI) != null) {
            AttachmentReference attachmentReference = this.defaultReferenceAttachmentReferenceResolver.resolve((Object)relativeReference, new Object[]{baseReference});
            DocumentReference documentReference = attachmentReference.getDocumentReference();
            DocumentReference finalDocumentReference = this.resolveDocumentReference(relativeReference.getParent(), documentReference, baseReference);
            if (finalDocumentReference != documentReference || relativeReference.extractReference(EntityType.DOCUMENT) == null) {
                result = new AttachmentReference(attachmentReference.getName(), finalDocumentReference);
            }
        }
        return result;
    }
}

