/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;

@Component
@Named(value="macro")
@Singleton
public class CurrentMacroEntityReferenceResolver
implements EntityReferenceResolver<String> {
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<String> currentEntityReferenceResolver;

    public EntityReference resolve(String representation, EntityType entityType, Object ... parameters) {
        EntityReference result;
        if (parameters.length < 1 || !(parameters[0] instanceof Block)) {
            throw new IllegalArgumentException(String.format("There must be at least one parameter, with the first parameter of type [%s]", Block.class.getName()));
        }
        Block currentBlock = (Block)parameters[0];
        MetaDataBlock metaDataBlock = (MetaDataBlock)currentBlock.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("base"), Block.Axes.ANCESTOR);
        if (metaDataBlock == null) {
            result = this.resolveWhenNoBASEMetaData(representation, entityType, parameters);
        } else {
            String sourceMetaData = (String)metaDataBlock.getMetaData().getMetaData("base");
            result = this.currentEntityReferenceResolver.resolve((Object)representation, entityType, new Object[]{this.currentEntityReferenceResolver.resolve((Object)sourceMetaData, EntityType.DOCUMENT, new Object[0])});
        }
        return result;
    }

    private EntityReference resolveWhenNoBASEMetaData(String representation, EntityType entityType, Object ... parameters) {
        EntityReference result;
        if (parameters.length > 1) {
            Object[] newParameters = new Object[parameters.length - 1];
            System.arraycopy(parameters, 1, newParameters, 0, parameters.length - 1);
            result = this.currentEntityReferenceResolver.resolve((Object)representation, entityType, newParameters);
        } else {
            result = this.currentEntityReferenceResolver.resolve((Object)representation, entityType, new Object[0]);
        }
        return result;
    }
}

