/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.DefaultRenderingContext;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.skin.SkinManager;
import org.xwiki.velocity.VelocityManager;

@Component
@Singleton
public class XWikiRenderingContext
extends DefaultRenderingContext {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<SkinManager> skinManagerProvider;
    @Inject
    private Logger logger;
    private VelocityManager velocityManager;

    private VelocityManager getVelocityManager() {
        if (this.velocityManager == null) {
            try {
                this.velocityManager = (VelocityManager)this.componentManager.getInstance(VelocityManager.class);
            }
            catch (ComponentLookupException e) {
                this.logger.debug("Failed to initialize VelocityManager, velocity cache won't be cleaned", (Throwable)e);
            }
        }
        return this.velocityManager;
    }

    public void push(Transformation transformation, XDOM xdom, Syntax syntax, String id, boolean restricted, Syntax targetSyntax) {
        super.push(transformation, xdom, syntax, id, restricted, targetSyntax);
        String namespace = id;
        if (namespace != null) {
            this.openNamespace(namespace);
        }
    }

    public void pop() {
        String namespace = this.peek().getTransformationId();
        if (namespace != null) {
            this.closeNamespace(namespace);
        }
        super.pop();
    }

    private void openNamespace(String namespace) {
        if (this.getVelocityManager() != null) {
            try {
                this.getVelocityManager().getVelocityEngine().startedUsingMacroNamespace(namespace);
                this.logger.debug("Started using velocity macro namespace [{}].", (Object)namespace);
            }
            catch (Exception e) {
                this.logger.warn("Failed to notify Velocity Macro cache for opening the [{}] namespace. Reason = [{}]", (Object)namespace, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    private void closeNamespace(String namespace) {
        if (this.getVelocityManager() != null) {
            try {
                this.getVelocityManager().getVelocityEngine().stoppedUsingMacroNamespace(namespace);
                this.logger.debug("Stopped using velocity macro namespace [{}].", (Object)namespace);
            }
            catch (Exception e) {
                this.logger.warn("Failed to notify Velocity Macro cache for closing the [{}] namespace. Reason = [{}]", (Object)namespace, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    public Syntax getTargetSyntax() {
        Syntax targetSyntax = super.getTargetSyntax();
        if (targetSyntax == null) {
            targetSyntax = ((SkinManager)this.skinManagerProvider.get()).getCurrentSkin(true).getOutputSyntax();
        }
        return targetSyntax;
    }
}

