/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.velocity;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.script.AbstractScriptMacro;
import org.xwiki.rendering.macro.velocity.VelocityMacroConfiguration;
import org.xwiki.rendering.macro.velocity.VelocityMacroParameters;
import org.xwiki.rendering.macro.velocity.filter.VelocityMacroFilter;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.VelocityTemplate;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@Named(value="velocity")
@Singleton
public class VelocityMacro
extends AbstractScriptMacro<VelocityMacroParameters> {
    public static final String MACRO_ATTRIBUTE = "velocity.template";
    private static final String DESCRIPTION = "Executes a Velocity script.";
    private static final String CONTENT_DESCRIPTION = "the velocity script to execute";
    private static final MetadataBlockMatcher METADATA_SOURCE_MATCHER = new MetadataBlockMatcher("source");
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private VelocityMacroConfiguration configuration;
    @Inject
    private Logger logger;

    public VelocityMacro() {
        super("Velocity", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), VelocityMacroParameters.class);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected String evaluateString(VelocityMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String result = "";
        try {
            VelocityContext velocityContext = this.velocityManager.getVelocityContext();
            VelocityMacroFilter filter = this.getFilter(parameters.getFilter());
            StringWriter writer = new StringWriter();
            String key = context.getTransformationContext().getId();
            if (key == null) {
                key = "unknown namespace";
            }
            VelocityEngine velocityEngine = this.velocityManager.getVelocityEngine();
            ProtectedVelocityTemplate protectedTemplate = (ProtectedVelocityTemplate)context.getCurrentMacroBlock().getAttribute(MACRO_ATTRIBUTE);
            if (protectedTemplate != null && filter == protectedTemplate.filter) {
                VelocityTemplate template = protectedTemplate.velocityTemplate;
                if (filter != null) {
                    filter.before(template, velocityContext);
                }
                velocityEngine.evaluate((Context)velocityContext, (Writer)writer, key, template);
            } else {
                String cleanedContent = content;
                if (filter != null) {
                    cleanedContent = filter.before(cleanedContent, velocityContext);
                }
                velocityEngine.evaluate((Context)velocityContext, (Writer)writer, key, (Reader)new StringReader(cleanedContent));
            }
            result = writer.toString();
            if (filter != null) {
                result = filter.after(result, velocityContext);
            }
        }
        catch (XWikiVelocityException e) {
            throw new MacroExecutionException("Failed to evaluate Velocity Macro for content [" + content + "]", (Throwable)e);
        }
        return result;
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        VelocityMacroFilter filter = this.getFilter(macroBlock.getParameter("filter"));
        if (filter == null || filter.isPreparationSupported()) {
            VelocityTemplate template;
            String metadataSource;
            String sourceName = "Unknown velocity MacroBlock";
            MetaDataBlock metadataBlock = (MetaDataBlock)macroBlock.getFirstBlock((BlockMatcher)METADATA_SOURCE_MATCHER, Block.Axes.ANCESTOR);
            if (metadataBlock != null && (metadataSource = (String)metadataBlock.getMetaData().getMetaData("source")) != null) {
                sourceName = metadataSource;
            }
            try {
                String preparedContent = macroBlock.getContent();
                if (filter != null) {
                    preparedContent = filter.prepare(preparedContent);
                }
                template = this.velocityManager.compile(sourceName, (Reader)new StringReader(preparedContent));
            }
            catch (XWikiVelocityException e) {
                throw new MacroPreparationException("Failed to compile the Velocity script", (Throwable)e);
            }
            macroBlock.setAttribute(MACRO_ATTRIBUTE, (Object)new ProtectedVelocityTemplate(template, filter));
        }
    }

    private VelocityMacroFilter getFilter(String filterName) {
        String finalFilter = filterName;
        if (StringUtils.isEmpty((CharSequence)finalFilter)) {
            finalFilter = this.configuration.getFilter();
        }
        VelocityMacroFilter filter = null;
        if (StringUtils.isNotEmpty((CharSequence)finalFilter)) {
            try {
                filter = (VelocityMacroFilter)this.getComponentManager().getInstance(VelocityMacroFilter.class, finalFilter);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Can't find velocity macro filter", (Throwable)e);
            }
        }
        return filter;
    }

    private class ProtectedVelocityTemplate {
        private final VelocityTemplate velocityTemplate;
        private final VelocityMacroFilter filter;

        ProtectedVelocityTemplate(VelocityTemplate velocityTemplate, VelocityMacroFilter filter) {
            this.velocityTemplate = velocityTemplate;
            this.filter = filter;
        }
    }
}

